/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.Marshallable;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public interface ScalarMarshaller<T>
extends Marshallable<T> {
    public WireType getWireType();

    default public <V> ProtoStreamMarshaller<V> toMarshaller(Class<V> targetClass, Function<V, T> unwrapper, Function<T, V> wrapper) {
        return this.toMarshaller(targetClass, (Predicate<V>)org.wildfly.clustering.function.Predicate.never(), unwrapper, (Supplier<V>)org.wildfly.clustering.function.Supplier.empty(), wrapper);
    }

    default public <V> ProtoStreamMarshaller<V> toMarshaller(Class<V> targetClass, Function<V, T> unwrapper, Supplier<V> defaultFactory, Function<T, V> wrapper) {
        return this.toMarshaller(targetClass, Objects::equals, unwrapper, defaultFactory, wrapper);
    }

    default public <V> ProtoStreamMarshaller<V> toMarshaller(Class<V> targetClass, final BiPredicate<T, T> equals, final Function<V, T> unwrapper, final Supplier<V> defaultFactory, Function<T, V> wrapper) {
        return this.toMarshaller(targetClass, (Predicate<V>)new org.wildfly.clustering.function.Predicate<V>(){

            public boolean test(V value) {
                return equals.test(unwrapper.apply(value), unwrapper.apply(defaultFactory.get()));
            }
        }, unwrapper, defaultFactory, wrapper);
    }

    default public ProtoStreamMarshaller<Optional<T>> toMarshaller() {
        return this.toMarshaller(Function.identity(), Function.identity());
    }

    default public <V> ProtoStreamMarshaller<Optional<V>> toMarshaller(Function<V, T> unwrapper, Function<T, V> wrapper) {
        return this.toMarshaller((Class<V>)Optional.class, (Predicate<V>)((Predicate<Optional>)Optional::isEmpty), (Function<V, T>)unwrapper.compose(Optional::get), (Supplier<V>)org.wildfly.clustering.function.Supplier.of(Optional.empty()), (Function<T, V>)wrapper.andThen(Optional::of));
    }

    default public <V> ProtoStreamMarshaller<V> toMarshaller(final Class<V> targetClass, final Predicate<V> skipWrite, final Function<V, T> unwrapper, final Supplier<V> defaultFactory, final Function<T, V> wrapper) {
        final ScalarMarshaller marshaller = this;
        return new ProtoStreamMarshaller<V>(){

            @Override
            public Class<? extends V> getJavaClass() {
                return targetClass;
            }

            @Override
            public V readFrom(ProtoStreamReader reader) throws IOException {
                Object value = defaultFactory.get();
                block3: while (!reader.isAtEnd()) {
                    int tag = reader.readTag();
                    switch (WireType.getTagFieldNumber((int)tag)) {
                        case 1: {
                            value = wrapper.apply(marshaller.readFrom(reader));
                            continue block3;
                        }
                    }
                    reader.skipField(tag);
                }
                return value;
            }

            @Override
            public void writeTo(ProtoStreamWriter writer, V value) throws IOException {
                if (!skipWrite.test(value)) {
                    writer.writeTag(1, marshaller.getWireType());
                    marshaller.writeTo(writer, unwrapper.apply(value));
                }
            }
        };
    }
}

