/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.annotations.Proto;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoSchema;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamTesterFactory;

public class NativeProtoStreamTestCase {
    @Test
    public void test() {
        ProtoStreamTesterFactory factory = new ProtoStreamTesterFactory();
        factory.createTester(Sex.class).run();
        Employee head = new Employee(1, new Name("Allegra", "Coleman"), Sex.FEMALE, null);
        Employee manager = new Employee(2, new Name("John", "Barron"), Sex.MALE, head);
        Employee employee = new Employee(3, new Name("Alan", "Smithee"), Sex.MALE, manager);
        factory.createTester(NativeProtoStreamTestCase::assertEquals).accept((Object)employee);
    }

    static void assertEquals(Employee expected, Employee actual) {
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
        Assertions.assertThat((Object)actual.getName()).isEqualTo((Object)expected.getName());
        Assertions.assertThat((Comparable)((Object)actual.getSex())).isSameAs((Object)expected.getSex());
        Assertions.assertThat((boolean)actual.isHead()).isEqualTo(expected.isHead());
        if (!expected.isHead()) {
            Assertions.assertThat((Object)actual.getManager()).isEqualTo((Object)expected.getManager());
        }
    }

    static enum Sex {
        MALE,
        FEMALE;

    }

    static class Employee {
        private final Integer id;
        private final Name name;
        private final Sex sex;
        private final Employee manager;

        @ProtoFactory
        Employee(Integer id, Name name, Sex sex, Employee manager) {
            this.id = id;
            this.name = name;
            this.sex = sex;
            this.manager = manager;
        }

        @ProtoField(value=1)
        Integer getId() {
            return this.id;
        }

        @ProtoField(value=2)
        Name getName() {
            return this.name;
        }

        @ProtoField(value=3)
        Sex getSex() {
            return this.sex;
        }

        @ProtoField(value=4)
        Employee getManager() {
            return this.manager;
        }

        boolean isHead() {
            return this.manager == null;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Employee)) {
                return false;
            }
            Employee employee = (Employee)object;
            return Objects.equals(this.id, employee.id);
        }
    }

    @Proto
    record Name(String first, String last) {
    }

    @ProtoSchema(includeClasses={Sex.class, Name.class, Employee.class})
    static interface EmployeeInitializer
    extends SerializationContextInitializer {
    }
}

