/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.test.Person;

public enum PersonMarshaller implements ProtoStreamMarshaller<Person>
{
    INSTANCE;

    private static final int NAME_INDEX = 1;
    private static final int PARENT_INDEX = 2;
    private static final int CHILD_INDEX = 3;

    public Class<? extends Person> getJavaClass() {
        return Person.class;
    }

    public Person readFrom(ProtoStreamReader reader) throws IOException {
        Person person = new Person();
        reader.getContext().record((Object)person);
        block5: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    person.setName(reader.readString());
                    continue block5;
                }
                case 2: {
                    ((Person)reader.readAny(Person.class)).addChild(person);
                    continue block5;
                }
                case 3: {
                    person.addChild((Person)reader.readAny(Person.class));
                    continue block5;
                }
            }
            reader.skipField(tag);
        }
        return person;
    }

    public void writeTo(ProtoStreamWriter writer, Person person) throws IOException {
        Person parent;
        writer.getContext().record((Object)person);
        String name = person.getName();
        if (name != null) {
            writer.writeString(1, person.getName());
        }
        if ((parent = person.getParent()) != null) {
            writer.writeAny(2, (Object)parent);
        }
        for (Person child : person.getChildren()) {
            writer.writeAny(3, (Object)child);
        }
    }
}

