/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.io.IOException;
import java.util.UUID;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.function.Function;
import org.wildfly.clustering.function.Supplier;
import org.wildfly.clustering.marshalling.protostream.FieldSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public enum UUIDMarshaller implements FieldSetMarshaller.Simple<UUID>
{
    INSTANCE;

    private static final UUID DEFAULT_VALUE;
    private static final int MOST_SIGNIFICANT_BITS_INDEX = 0;
    private static final int LEAST_SIGNIFICANT_BITS_INDEX = 1;
    private static final int FIELDS = 2;

    @Override
    public UUID createInitialValue() {
        return DEFAULT_VALUE;
    }

    @Override
    public int getFields() {
        return 2;
    }

    @Override
    public UUID readFrom(ProtoStreamReader reader, int index, WireType type, UUID id) throws IOException {
        return switch (index) {
            case 0 -> new UUID(reader.readSFixed64(), id.getLeastSignificantBits());
            case 1 -> new UUID(id.getMostSignificantBits(), reader.readSFixed64());
            default -> (UUID)Supplier.call(() -> reader.skipField(type), null).thenApply((java.util.function.Function)Function.of((Object)id)).get();
        };
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, UUID uuid) throws IOException {
        long leastSignificantBits;
        long mostSignificantBits = uuid.getMostSignificantBits();
        if (mostSignificantBits != DEFAULT_VALUE.getMostSignificantBits()) {
            writer.writeSFixed64(0, mostSignificantBits);
        }
        if ((leastSignificantBits = uuid.getLeastSignificantBits()) != DEFAULT_VALUE.getLeastSignificantBits()) {
            writer.writeSFixed64(1, leastSignificantBits);
        }
    }

    static {
        DEFAULT_VALUE = new UUID(0L, 0L);
    }
}

