/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.FieldReadable;
import org.wildfly.clustering.marshalling.protostream.FieldSetReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamOperation;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;

public class OffsetProtoStreamReader
implements ProtoStreamReader {
    private final ProtoStreamReader reader;
    private final int offset;

    OffsetProtoStreamReader(ProtoStreamReader reader, int offset) {
        this.reader = reader;
        this.offset = offset;
    }

    @Override
    public ProtoStreamOperation.Context getContext() {
        return this.reader.getContext();
    }

    @Override
    public ImmutableSerializationContext getSerializationContext() {
        return this.reader.getSerializationContext();
    }

    @Override
    public <T> FieldSetReader<T> createFieldSetReader(final FieldReadable<T> reader, final int startIndex) {
        final int endIndex = reader.nextIndex(startIndex);
        final int absoluteStartIndex = this.offset + startIndex;
        final OffsetProtoStreamReader offsetReader = new OffsetProtoStreamReader(this, absoluteStartIndex);
        return new FieldSetReader<T>(this){
            final /* synthetic */ OffsetProtoStreamReader this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public T readField(T current) throws IOException {
                int tag = offsetReader.getCurrentTag();
                int relativeIndex = WireType.getTagFieldNumber((int)tag) - absoluteStartIndex;
                return reader.readFrom(offsetReader, relativeIndex, WireType.fromTag((int)tag), current);
            }

            @Override
            public boolean contains(int index) {
                return index >= startIndex && index < endIndex;
            }
        };
    }

    @Override
    public int getCurrentTag() {
        return this.reader.getCurrentTag();
    }

    public boolean isAtEnd() throws IOException {
        return this.reader.isAtEnd();
    }

    public int readTag() throws IOException {
        return this.reader.readTag();
    }

    public byte readByteTag() throws IOException {
        return this.reader.readByteTag();
    }

    public void checkLastTagWas(int tag) throws IOException {
        this.reader.checkLastTagWas(tag);
    }

    public boolean skipField(int tag) throws IOException {
        return this.reader.skipField(tag);
    }

    public boolean readBool() throws IOException {
        return this.reader.readBool();
    }

    public int readEnum() throws IOException {
        return this.reader.readEnum();
    }

    public String readString() throws IOException {
        return this.reader.readString();
    }

    public byte[] readByteArray() throws IOException {
        return this.reader.readByteArray();
    }

    public ByteBuffer readByteBuffer() throws IOException {
        return this.reader.readByteBuffer();
    }

    public double readDouble() throws IOException {
        return this.reader.readDouble();
    }

    public float readFloat() throws IOException {
        return this.reader.readFloat();
    }

    public long readUInt64() throws IOException {
        return this.reader.readUInt64();
    }

    public long readSInt64() throws IOException {
        return this.reader.readSFixed64();
    }

    public long readSFixed64() throws IOException {
        return this.reader.readSFixed64();
    }

    public int readUInt32() throws IOException {
        return this.reader.readUInt32();
    }

    public int readSInt32() throws IOException {
        return this.reader.readSInt32();
    }

    public int readSFixed32() throws IOException {
        return this.reader.readSFixed32();
    }

    public int pushLimit(int limit) throws IOException {
        return this.reader.pushLimit(limit);
    }

    public void popLimit(int oldLimit) {
        this.reader.popLimit(oldLimit);
    }

    public byte[] fullBufferArray() throws IOException {
        return this.reader.fullBufferArray();
    }

    public InputStream fullBufferInputStream() throws IOException {
        return this.reader.fullBufferInputStream();
    }

    public boolean isInputStream() {
        return this.reader.isInputStream();
    }

    @Override
    public Object readAny() throws IOException {
        return this.reader.readAny();
    }

    @Override
    public <T> T readObject(Class<T> targetClass) throws IOException {
        return this.reader.readObject(targetClass);
    }

    @Override
    @Deprecated
    public int readInt32() throws IOException {
        return this.reader.readInt32();
    }

    @Override
    @Deprecated
    public int readFixed32() throws IOException {
        return this.reader.readFixed32();
    }

    @Override
    @Deprecated
    public long readInt64() throws IOException {
        return this.reader.readInt64();
    }

    @Override
    @Deprecated
    public long readFixed64() throws IOException {
        return this.reader.readFixed64();
    }
}

