/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.function.Consumer;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.FileDescriptorSource;
import org.wildfly.clustering.marshalling.protostream.Privileged;
import org.wildfly.clustering.marshalling.protostream.SerializationContext;
import org.wildfly.clustering.marshalling.protostream.SerializationContextInitializer;

public class SchemaRegistrar
implements Consumer<SerializationContext> {
    private final String resourceName;
    private final ClassLoader loader;

    public SchemaRegistrar(Class<? extends SerializationContextInitializer> initializerClass) {
        this(initializerClass, initializerClass.getPackage());
    }

    public SchemaRegistrar(Class<? extends SerializationContextInitializer> initializerClass, Package schemaPackage) {
        this.resourceName = schemaPackage.getName() + ".proto";
        this.loader = Privileged.getClassLoader(this.getClass());
    }

    @Override
    public void accept(SerializationContext context) {
        try {
            context.registerProtoFiles(SchemaRegistrar.getFileDescriptorSource(this.loader, this.resourceName));
        }
        catch (DescriptorParserException e) {
            try {
                context.unregisterProtoFile(this.resourceName);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            throw e;
        }
    }

    public String toString() {
        return this.resourceName;
    }

    private static FileDescriptorSource getFileDescriptorSource(final ClassLoader loader, final String resourceName) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileDescriptorSource>(){

                @Override
                public FileDescriptorSource run() throws Exception {
                    return FileDescriptorSource.fromResources((ClassLoader)loader, (String[])new String[]{resourceName});
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception exception = e.getException();
            if (exception instanceof IOException) {
                IOException ioe = (IOException)exception;
                throw new UncheckedIOException(ioe);
            }
            throw new RuntimeException(exception);
        }
    }
}

