/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.test.TestRecord;

public enum TestRecordMarshaller implements ProtoStreamMarshaller<TestRecord>
{
    INSTANCE;

    private static final int NAME_INDEX = 1;
    private static final int VALUE_INDEX = 2;

    public Class<? extends TestRecord> getJavaClass() {
        return TestRecord.class;
    }

    public TestRecord readFrom(ProtoStreamReader reader) throws IOException {
        String name = null;
        Integer value = null;
        block4: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    name = reader.readString();
                    continue block4;
                }
                case 2: {
                    value = reader.readSFixed32();
                    continue block4;
                }
            }
            reader.skipField(tag);
        }
        return new TestRecord(name, value);
    }

    public void writeTo(ProtoStreamWriter writer, TestRecord record) throws IOException {
        if (record.name() != null) {
            writer.writeString(1, record.name());
        }
        if (record.value() != null) {
            writer.writeSFixed32(2, record.value().intValue());
        }
    }
}

