/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.time;

import java.io.IOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.function.Supplier;
import org.wildfly.clustering.marshalling.protostream.FieldSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public enum DurationMarshaller implements FieldSetMarshaller.Simple<Duration>
{
    INSTANCE;

    private static final int NANOS_PER_MILLI;
    private static final Set<ChronoUnit> SUPER_SECOND_UNITS;
    private static final Set<ChronoUnit> SUB_MILLSECOND_UNITS;
    private static final int POSITIVE_SECONDS_INDEX = 0;
    private static final int NEGATIVE_SECONDS_INDEX = 1;
    private static final int MILLIS_INDEX = 2;
    private static final int NANOS_INDEX = 3;
    private static final int FIELDS = 4;

    @Override
    public Duration createInitialValue() {
        return Duration.ZERO;
    }

    @Override
    public int getFields() {
        return 4;
    }

    @Override
    public Duration readFrom(ProtoStreamReader reader, int index, WireType type, Duration duration) throws IOException {
        return switch (index) {
            case 0 -> DurationMarshaller.withSeconds(duration, reader.readUInt64());
            case 1 -> duration.withSeconds(0L - reader.readUInt64());
            case 2 -> DurationMarshaller.withMillis(duration, reader.readUInt32());
            case 3 -> DurationMarshaller.withNanos(duration, reader.readUInt32());
            default -> (Duration)Supplier.call(() -> reader.skipField(type), null).thenApply((Function)org.wildfly.clustering.function.Function.of((Object)duration)).get();
        };
    }

    private static Duration withSeconds(Duration duration, long seconds) {
        if (duration.isZero()) {
            for (ChronoUnit unit : SUPER_SECOND_UNITS) {
                Duration unitDuration = unit.getDuration();
                if (unitDuration.getSeconds() != seconds) continue;
                return unitDuration;
            }
        }
        return duration.withSeconds(seconds);
    }

    private static Duration withMillis(Duration duration, int millis) {
        return duration.isZero() && millis == 1 ? ChronoUnit.MILLIS.getDuration() : duration.withNanos(millis * NANOS_PER_MILLI);
    }

    private static Duration withNanos(Duration duration, int nanos) {
        if (duration.isZero()) {
            for (ChronoUnit unit : SUB_MILLSECOND_UNITS) {
                Duration unitDuration = unit.getDuration();
                if (unitDuration.getNano() != nanos) continue;
                return unitDuration;
            }
        }
        return duration.withNanos(nanos);
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, Duration duration) throws IOException {
        long seconds = duration.getSeconds();
        if (seconds > 0L) {
            writer.writeUInt64(0, seconds);
        } else if (seconds < 0L) {
            writer.writeUInt64(1, 0L - seconds);
        }
        int nanos = duration.getNano();
        if (nanos > 0) {
            if (nanos % NANOS_PER_MILLI == 0) {
                writer.writeUInt32(2, nanos / NANOS_PER_MILLI);
            } else {
                writer.writeUInt32(3, nanos);
            }
        }
    }

    static {
        NANOS_PER_MILLI = ChronoUnit.MILLIS.getDuration().getNano();
        SUPER_SECOND_UNITS = EnumSet.of(ChronoUnit.SECONDS, ChronoUnit.MINUTES, ChronoUnit.HOURS, ChronoUnit.HALF_DAYS, ChronoUnit.DAYS);
        SUB_MILLSECOND_UNITS = EnumSet.of(ChronoUnit.NANOS, ChronoUnit.MICROS);
    }
}

