/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public enum CalendarMarshaller implements ProtoStreamMarshaller<Calendar>
{
    INSTANCE;

    private static final int TYPE_INDEX = 1;
    private static final int TIME_INDEX = 2;
    private static final int LENIENT_INDEX = 3;
    private static final int TIME_ZONE_INDEX = 4;
    private static final int FIRST_DAY_OF_WEEK_INDEX = 5;
    private static final int MIN_DAYS_IN_FIRST_WEEK_INDEX = 6;
    private static final Calendar DEFAULT;

    @Override
    public Calendar readFrom(ProtoStreamReader reader) throws IOException {
        Calendar.Builder builder = new Calendar.Builder().setInstant(0L);
        int firstDayOfWeek = DEFAULT.getFirstDayOfWeek();
        int minDaysInFirstWeek = DEFAULT.getMinimalDaysInFirstWeek();
        block8: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    builder.setCalendarType(reader.readString());
                    continue block8;
                }
                case 2: {
                    builder.setInstant(reader.readObject(Date.class));
                    continue block8;
                }
                case 3: {
                    builder.setLenient(reader.readBool());
                    continue block8;
                }
                case 4: {
                    builder.setTimeZone(TimeZone.getTimeZone(reader.readString()));
                    continue block8;
                }
                case 5: {
                    firstDayOfWeek = reader.readUInt32();
                    continue block8;
                }
                case 6: {
                    minDaysInFirstWeek = reader.readUInt32();
                    continue block8;
                }
            }
            reader.skipField(tag);
        }
        return builder.setWeekDefinition(firstDayOfWeek, minDaysInFirstWeek).build();
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, Calendar calendar) throws IOException {
        int minDaysInFirstWeek;
        int firstDayOfWeek;
        TimeZone zone;
        boolean lenient;
        Date time;
        String type = calendar.getCalendarType();
        if (!type.equals(DEFAULT.getCalendarType())) {
            writer.writeString(1, type);
        }
        if (!(time = calendar.getTime()).equals(DEFAULT.getTime())) {
            writer.writeObject(2, time);
        }
        if ((lenient = calendar.isLenient()) != DEFAULT.isLenient()) {
            writer.writeBool(3, lenient);
        }
        if (!(zone = calendar.getTimeZone()).equals(DEFAULT.getTimeZone())) {
            writer.writeString(4, zone.getID());
        }
        if ((firstDayOfWeek = calendar.getFirstDayOfWeek()) != DEFAULT.getFirstDayOfWeek()) {
            writer.writeUInt32(5, firstDayOfWeek);
        }
        if ((minDaysInFirstWeek = calendar.getMinimalDaysInFirstWeek()) != DEFAULT.getMinimalDaysInFirstWeek()) {
            writer.writeUInt32(6, minDaysInFirstWeek);
        }
    }

    @Override
    public Class<? extends Calendar> getJavaClass() {
        return Calendar.class;
    }

    static {
        DEFAULT = new Calendar.Builder().setInstant(0L).build();
    }
}

