/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.marshalling.MarshallingTester;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;
import org.wildfly.clustering.marshalling.test.TestInvocationHandler;

public abstract class AbstractLangTestCase {
    private final MarshallingTesterFactory factory;

    public AbstractLangTestCase(MarshallingTesterFactory factory) {
        this.factory = factory;
    }

    @Test
    public void testBoolean() throws IOException {
        this.factory.createTester().test(true);
    }

    @Test
    public void testByte() throws IOException {
        MarshallingTester<Byte> tester = this.factory.createTester();
        for (int i = 0; i < 8; ++i) {
            tester.test(Integer.valueOf((1 << i) - 1).byteValue());
            tester.test(Integer.valueOf(-1 << i).byteValue());
        }
    }

    @Test
    public void testShort() throws IOException {
        MarshallingTester<Short> tester = this.factory.createTester();
        for (int i = 0; i < 16; ++i) {
            tester.test(Integer.valueOf((1 << i) - 1).shortValue());
            tester.test(Integer.valueOf(-1 << i).shortValue());
        }
    }

    @Test
    public void testInteger() throws IOException {
        MarshallingTester<Integer> tester = this.factory.createTester();
        for (int i = 0; i < 32; ++i) {
            tester.test((1 << i) - 1);
            tester.test(-1 << i);
        }
    }

    @Test
    public void testLong() throws IOException {
        MarshallingTester<Long> tester = this.factory.createTester();
        for (int i = 0; i < 64; ++i) {
            tester.test((1L << i) - 1L);
            tester.test(-1L << i);
        }
    }

    @Test
    public void testFloat() throws IOException {
        MarshallingTester<Float> tester = this.factory.createTester();
        tester.test(Float.valueOf(Float.NEGATIVE_INFINITY));
        tester.test(Float.valueOf(Float.MIN_VALUE));
        tester.test(Float.valueOf(0.0f));
        tester.test(Float.valueOf(Float.MAX_VALUE));
        tester.test(Float.valueOf(Float.POSITIVE_INFINITY));
        tester.test(Float.valueOf(Float.NaN));
    }

    @Test
    public void testDouble() throws IOException {
        MarshallingTester<Double> tester = this.factory.createTester();
        tester.test(Double.NEGATIVE_INFINITY);
        tester.test((Double)Double.MIN_VALUE);
        tester.test(0.0);
        tester.test((Double)Double.MAX_VALUE);
        tester.test(Double.POSITIVE_INFINITY);
        tester.test(Double.NaN);
    }

    @Test
    public void testCharacter() throws IOException {
        MarshallingTester<Character> tester = this.factory.createTester();
        tester.test(Character.valueOf('\u0000'));
        tester.test(Character.valueOf('A'));
        tester.test(Character.valueOf('\uffff'));
    }

    @Test
    public void testString() throws IOException {
        MarshallingTester<String> tester = this.factory.createTester();
        tester.test("A");
        tester.test(UUID.randomUUID().toString());
    }

    @Test
    public void testBooleanArray() throws IOException {
        boolean[] array = new boolean[]{true, false};
        this.factory.createTester().test(array, Assertions::assertArrayEquals);
        this.factory.createTester().test(new boolean[][]{array, array}, Assertions::assertArrayEquals);
        Boolean[] objectArray = new Boolean[]{true, false};
        this.factory.createTester().test(objectArray, Assertions::assertArrayEquals);
        this.factory.createTester().test(new Boolean[][]{objectArray, objectArray}, Assertions::assertArrayEquals);
        this.factory.createTester().test(new Object[][]{objectArray, objectArray}, Assertions::assertArrayEquals);
    }

    @Test
    public void testByteArray() throws IOException {
        byte[] array = new byte[]{-128, 0, 127};
        this.factory.createTester().test(array, Assertions::assertArrayEquals);
        this.factory.createTester().test(new byte[][]{array, array}, Assertions::assertArrayEquals);
        Byte[] objectArray = new Byte[]{(byte)-128, (byte)0, (byte)127};
        this.factory.createTester().test(objectArray, Assertions::assertArrayEquals);
        this.factory.createTester().test(new Byte[][]{objectArray, objectArray}, Assertions::assertArrayEquals);
        this.factory.createTester().test(new Object[][]{objectArray, objectArray}, Assertions::assertArrayEquals);
    }

    @Test
    public void testShortArray() throws IOException {
        short[] array = new short[]{Short.MIN_VALUE, 0, Short.MAX_VALUE};
        this.factory.createTester().test(array, Assertions::assertArrayEquals);
        this.factory.createTester().test(new short[][]{array, array}, Assertions::assertArrayEquals);
        Short[] objectArray = new Short[]{(short)Short.MIN_VALUE, (short)0, (short)Short.MAX_VALUE};
        this.factory.createTester().test(objectArray, Assertions::assertArrayEquals);
        this.factory.createTester().test(new Short[][]{objectArray, objectArray}, Assertions::assertArrayEquals);
        this.factory.createTester().test(new Object[][]{objectArray, objectArray}, Assertions::assertArrayEquals);
    }

    @Test
    public void testIntegerArray() throws IOException {
        int[] array = new int[]{Integer.MIN_VALUE, 0, Integer.MAX_VALUE};
        this.factory.createTester().test(array, Assertions::assertArrayEquals);
        this.factory.createTester().test(new int[][]{array, array}, Assertions::assertArrayEquals);
        Integer[] objectArray = new Integer[]{Integer.MIN_VALUE, 0, Integer.MAX_VALUE};
        this.factory.createTester().test(objectArray, Assertions::assertArrayEquals);
        this.factory.createTester().test(new Integer[][]{objectArray, objectArray}, Assertions::assertArrayEquals);
        this.factory.createTester().test(new Object[][]{objectArray, objectArray}, Assertions::assertArrayEquals);
    }

    @Test
    public void testLongArray() throws IOException {
        long[] array = new long[]{Long.MIN_VALUE, 0L, Long.MAX_VALUE};
        this.factory.createTester().test(array, Assertions::assertArrayEquals);
        this.factory.createTester().test(new long[][]{array, array}, Assertions::assertArrayEquals);
        Long[] objectArray = new Long[]{Long.MIN_VALUE, 0L, Long.MAX_VALUE};
        this.factory.createTester().test(objectArray, Assertions::assertArrayEquals);
        this.factory.createTester().test(new Long[][]{objectArray, objectArray}, Assertions::assertArrayEquals);
        this.factory.createTester().test(new Object[][]{objectArray, objectArray}, Assertions::assertArrayEquals);
    }

    @Test
    public void testFloatArray() throws IOException {
        float[] array = new float[]{Float.MIN_VALUE, 0.0f, Float.MAX_VALUE};
        this.factory.createTester().test(array, Assertions::assertArrayEquals);
        this.factory.createTester().test(new float[][]{array, array}, Assertions::assertArrayEquals);
        Float[] objectArray = new Float[]{Float.valueOf(Float.MIN_VALUE), Float.valueOf(0.0f), Float.valueOf(Float.MAX_VALUE)};
        this.factory.createTester().test(objectArray, Assertions::assertArrayEquals);
        this.factory.createTester().test(new Float[][]{objectArray, objectArray}, Assertions::assertArrayEquals);
        this.factory.createTester().test(new Object[][]{objectArray, objectArray}, Assertions::assertArrayEquals);
    }

    @Test
    public void testDoubleArray() throws IOException {
        double[] array = new double[]{Double.MIN_VALUE, 0.0, Double.MAX_VALUE};
        this.factory.createTester().test(array, Assertions::assertArrayEquals);
        this.factory.createTester().test(new double[][]{array, array}, Assertions::assertArrayEquals);
        Double[] objectArray = new Double[]{Double.MIN_VALUE, 0.0, Double.MAX_VALUE};
        this.factory.createTester().test(objectArray, Assertions::assertArrayEquals);
        this.factory.createTester().test(new Double[][]{objectArray, objectArray}, Assertions::assertArrayEquals);
        this.factory.createTester().test(new Object[][]{objectArray, objectArray}, Assertions::assertArrayEquals);
    }

    @Test
    public void testCharArray() throws IOException {
        char[] array = new char[]{'\u0000', 'A', '\uffff'};
        this.factory.createTester().test(array, Assertions::assertArrayEquals);
        this.factory.createTester().test(new char[][]{array, array}, Assertions::assertArrayEquals);
        Character[] objectArray = new Character[]{Character.valueOf('\u0000'), Character.valueOf('A'), Character.valueOf('\uffff')};
        this.factory.createTester().test(objectArray, Assertions::assertArrayEquals);
        this.factory.createTester().test(new Character[][]{objectArray, objectArray}, Assertions::assertArrayEquals);
        this.factory.createTester().test(new Object[][]{objectArray, objectArray}, Assertions::assertArrayEquals);
    }

    @Test
    public void testObjectArray() throws IOException {
        String string1 = "foo";
        String string2 = "bar";
        String[] stringArray = new String[]{string1, string2};
        this.factory.createTester().test(stringArray, Assertions::assertArrayEquals);
        this.factory.createTester().test(new String[]{string1, string1}, Assertions::assertArrayEquals);
        this.factory.createTester().test(new String[][]{stringArray, stringArray}, Assertions::assertArrayEquals);
        this.factory.createTester().test(new Object[][]{stringArray, stringArray}, Assertions::assertArrayEquals);
    }

    @Test
    public void testNull() throws IOException {
        this.factory.createTester().test(null, Assertions::assertSame);
    }

    @Test
    public void testClass() throws IOException {
        MarshallingTester<Class> tester = this.factory.createTester();
        tester.test(Object.class, Assertions::assertSame);
        tester.test(Integer.class, Assertions::assertSame);
        tester.test(Throwable.class, Assertions::assertSame);
        tester.test(Exception.class, Assertions::assertSame);
    }

    @Test
    public void testException() throws IOException {
        RuntimeException exception = new RuntimeException("foo");
        exception.setStackTrace(new StackTraceElement[]{exception.getStackTrace()[0]});
        Exception cause = new Exception("bar");
        cause.setStackTrace(new StackTraceElement[]{cause.getStackTrace()[0]});
        Error suppressed = new Error("baz");
        suppressed.setStackTrace(new StackTraceElement[]{suppressed.getStackTrace()[0]});
        exception.initCause(cause);
        exception.addSuppressed(suppressed);
        this.factory.createTester().test(exception, AbstractLangTestCase::assertEquals);
    }

    @Test
    public void testStackTrace() throws IOException {
        this.factory.createTester().test(new StackTraceElement("class", "method", "file", -1), AbstractLangTestCase::assertEquals);
        this.factory.createTester().test(new StackTraceElement("loader", "module", "1.0", "class", "method", "file", 1), AbstractLangTestCase::assertEquals);
    }

    @Test
    public void testProxy() throws IOException {
        Object proxy = Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{Iterable.class}, (InvocationHandler)new TestInvocationHandler("foo"));
        this.factory.createTester().test(proxy, AbstractLangTestCase::assertProxyEquals);
    }

    private static void assertProxyEquals(Object expected, Object actual) {
        Assertions.assertTrue((boolean)Proxy.isProxyClass(actual.getClass()));
        TestInvocationHandler actualHandler = (TestInvocationHandler)Proxy.getInvocationHandler(actual);
        TestInvocationHandler expectedHandler = (TestInvocationHandler)Proxy.getInvocationHandler(expected);
        Assertions.assertEquals((Object)expectedHandler.getValue(), (Object)actualHandler.getValue());
    }

    private static void assertEquals(Throwable expected, Throwable actual) {
        Assertions.assertEquals((Object)expected.getMessage(), (Object)actual.getMessage());
        StackTraceElement[] expectedStackTrace = expected.getStackTrace();
        StackTraceElement[] actualStackTrace = expected.getStackTrace();
        Assertions.assertEquals((int)expectedStackTrace.length, (int)actualStackTrace.length);
        for (int i = 0; i < expectedStackTrace.length; ++i) {
            AbstractLangTestCase.assertEquals(expectedStackTrace[i], actualStackTrace[i]);
        }
        Throwable[] expectedSuppressed = expected.getSuppressed();
        Throwable[] actualSuppressed = actual.getSuppressed();
        Assertions.assertEquals((int)expectedSuppressed.length, (int)actualSuppressed.length);
        for (int i = 0; i < expectedSuppressed.length; ++i) {
            AbstractLangTestCase.assertEquals(expectedSuppressed[i], actualSuppressed[i]);
        }
        Throwable cause1 = expected.getCause();
        Throwable cause2 = actual.getCause();
        if (cause1 != null && cause2 != null) {
            AbstractLangTestCase.assertEquals(cause1, cause2);
        } else {
            Assertions.assertSame((Object)cause1, (Object)cause2);
        }
    }

    private static void assertEquals(StackTraceElement expected, StackTraceElement actual) {
        Assertions.assertEquals((Object)expected.getClassName(), (Object)actual.getClassName());
        Assertions.assertEquals((Object)expected.getMethodName(), (Object)actual.getMethodName());
        Assertions.assertEquals((Object)expected.getFileName(), (Object)actual.getFileName());
        Assertions.assertEquals((int)expected.getLineNumber(), (int)actual.getLineNumber());
        Assertions.assertEquals((Object)expected.getClassLoaderName(), (Object)actual.getClassLoaderName());
        Assertions.assertEquals((Object)expected.getModuleName(), (Object)actual.getModuleName());
        Assertions.assertEquals((Object)expected.getModuleVersion(), (Object)actual.getModuleVersion());
    }
}

