/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.marshalling.MarshallingTester;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;
import org.wildfly.clustering.marshalling.test.Empty;
import org.wildfly.clustering.marshalling.test.TestComparator;

public abstract class AbstractUtilTestCase {
    private static final Map<Object, Object> BASIS = Stream.of(1, 2, 3, 4, 5).collect(Collectors.toMap(i -> i, i -> Integer.toString(-i.intValue())));
    private final MarshallingTesterFactory factory;

    public AbstractUtilTestCase(MarshallingTesterFactory factory) {
        this.factory = factory;
    }

    @Test
    public void testArrayDeque() throws IOException {
        MarshallingTester<ArrayDeque> tester = this.factory.createTester();
        tester.test(new ArrayDeque<Object>(BASIS.keySet()), AbstractUtilTestCase::assertCollectionEquals);
    }

    @Test
    public void testArrayList() throws IOException {
        MarshallingTester<ArrayList> tester = this.factory.createTester();
        tester.test(new ArrayList<Object>(BASIS.keySet()), AbstractUtilTestCase::assertCollectionEquals);
    }

    @Test
    public void testBitSet() throws IOException {
        MarshallingTester<BitSet> tester = this.factory.createTester();
        tester.test(new BitSet(0));
        BitSet set = new BitSet(7);
        set.set(1);
        set.set(3);
        set.set(5);
        tester.test(set);
    }

    @Test
    public void testCalendar() throws IOException {
        MarshallingTester<Calendar> tester = this.factory.createTester();
        LocalDateTime time = LocalDateTime.now();
        tester.test(new Calendar.Builder().setDate(time.getYear(), time.getMonthValue(), time.getDayOfMonth()).build());
        tester.test(new Calendar.Builder().setLenient(false).setLocale(Locale.FRANCE).setDate(time.getYear(), time.getMonthValue() - 1, time.getDayOfMonth()).setTimeOfDay(time.getHour(), time.getMinute(), time.getSecond()).build());
        tester.test(new Calendar.Builder().setLocale(Locale.JAPAN).setTimeZone(TimeZone.getTimeZone("Asia/Tokyo")).setInstant(Date.from(time.toInstant(ZoneOffset.UTC))).build());
        tester.test(new Calendar.Builder().setLocale(Locale.forLanguageTag("th_TH")).setTimeZone(TimeZone.getTimeZone("Asia/Bangkok")).build());
    }

    @Test
    public void testCurrency() throws IOException {
        MarshallingTester<Currency> tester = this.factory.createTester();
        for (Currency currency : Currency.getAvailableCurrencies()) {
            tester.test(currency);
        }
    }

    @Test
    public void testDate() throws IOException {
        MarshallingTester<Date> tester = this.factory.createTester();
        tester.test(Date.from(Instant.EPOCH));
        tester.test(Date.from(Instant.now()));
    }

    @Test
    public void testEnumMap() throws IOException {
        MarshallingTester<EnumMap> tester = this.factory.createTester();
        EnumMap<Thread.State, String> map = new EnumMap<Thread.State, String>(Thread.State.class);
        tester.test(map, AbstractUtilTestCase::assertMapEquals);
        Iterator iterator = EnumSet.allOf(Thread.State.class).iterator();
        while (iterator.hasNext()) {
            Thread.State state;
            map.put(state, (state = (Thread.State)((Object)iterator.next())).ordinal() % 2 == 0 ? state.name() : null);
            tester.test(map, AbstractUtilTestCase::assertMapEquals);
        }
    }

    @Test
    public void testEnumSet() throws IOException {
        MarshallingTester<EnumSet> tester = this.factory.createTester();
        EnumSet<Thread.State> set = EnumSet.noneOf(Thread.State.class);
        tester.test(set, AbstractUtilTestCase::assertCollectionEquals);
        for (Thread.State state : EnumSet.allOf(Thread.State.class)) {
            set.add(state);
            tester.test(set, AbstractUtilTestCase::assertCollectionEquals);
        }
    }

    @Test
    public void testJumboEnumSet() throws IOException {
        MarshallingTester<EnumSet> tester = this.factory.createTester();
        tester.test(EnumSet.noneOf(Character.UnicodeScript.class), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(EnumSet.of(Character.UnicodeScript.UNKNOWN), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(EnumSet.of(Character.UnicodeScript.ARABIC, new Character.UnicodeScript[]{Character.UnicodeScript.ARMENIAN, Character.UnicodeScript.AVESTAN, Character.UnicodeScript.BALINESE, Character.UnicodeScript.BAMUM, Character.UnicodeScript.BATAK, Character.UnicodeScript.BENGALI, Character.UnicodeScript.BOPOMOFO, Character.UnicodeScript.BRAHMI, Character.UnicodeScript.BRAILLE, Character.UnicodeScript.BUGINESE, Character.UnicodeScript.BUHID, Character.UnicodeScript.CANADIAN_ABORIGINAL, Character.UnicodeScript.CARIAN}), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(EnumSet.complementOf(EnumSet.of(Character.UnicodeScript.UNKNOWN)), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(EnumSet.allOf(Character.UnicodeScript.class), AbstractUtilTestCase::assertCollectionEquals);
    }

    @Test
    public void testEmptyEnumSet() throws IOException {
        MarshallingTester<EnumSet> tester = this.factory.createTester();
        EnumSet<Empty> set = EnumSet.noneOf(Empty.class);
        tester.test(set, AbstractUtilTestCase::assertCollectionEquals);
    }

    @Test
    public void testHashMap() throws IOException {
        MarshallingTester<HashMap> tester = this.factory.createTester();
        tester.test(new HashMap<Object, Object>(BASIS), AbstractUtilTestCase::assertMapEquals);
    }

    @Test
    public void testHashSet() throws IOException {
        MarshallingTester<HashSet> tester = this.factory.createTester();
        tester.test(new HashSet<Object>(BASIS.keySet()), AbstractUtilTestCase::assertCollectionEquals);
    }

    @Test
    public void testLinkedHashMap() throws IOException {
        MarshallingTester<LinkedHashMap> tester = this.factory.createTester();
        tester.test(new LinkedHashMap<Object, Object>(BASIS), AbstractUtilTestCase::assertLinkedMapEquals);
        LinkedHashMap<Object, Object> accessOrderMap = new LinkedHashMap<Object, Object>(5, 1.0f, true);
        accessOrderMap.putAll(BASIS);
        tester.test(new LinkedHashMap(accessOrderMap), AbstractUtilTestCase::assertLinkedMapEquals);
    }

    @Test
    public void testLinkedHashSet() throws IOException {
        MarshallingTester<LinkedHashSet> tester = this.factory.createTester();
        tester.test(new LinkedHashSet<Object>(BASIS.keySet()), AbstractUtilTestCase::assertCollectionEquals);
    }

    @Test
    public void testLinkedList() throws IOException {
        MarshallingTester<LinkedList> tester = this.factory.createTester();
        tester.test(new LinkedList<Object>(BASIS.keySet()), AbstractUtilTestCase::assertCollectionEquals);
    }

    @Test
    public void testLocale() throws IOException {
        MarshallingTester<Locale> tester = this.factory.createTester();
        for (Locale locale : Locale.getAvailableLocales()) {
            tester.test(locale);
        }
    }

    @Test
    public void testSimpleEntry() throws IOException {
        MarshallingTester<AbstractMap.SimpleEntry<Object, Object>> tester = this.factory.createTester();
        String key = "key";
        String value = "value";
        tester.test(new AbstractMap.SimpleEntry<Object, Object>(null, null));
        tester.test(new AbstractMap.SimpleEntry<String, Object>(key, null));
        tester.test(new AbstractMap.SimpleEntry<String, String>(key, value));
        tester.test(new AbstractMap.SimpleEntry<String, String>(value, value));
    }

    @Test
    public void testSimpleImmutableEntry() throws IOException {
        MarshallingTester<AbstractMap.SimpleImmutableEntry<Object, Object>> tester = this.factory.createTester();
        String key = "key";
        String value = "value";
        tester.test(new AbstractMap.SimpleImmutableEntry<Object, Object>(null, null));
        tester.test(new AbstractMap.SimpleImmutableEntry<String, Object>(key, null));
        tester.test(new AbstractMap.SimpleImmutableEntry<String, String>(key, value));
        tester.test(new AbstractMap.SimpleImmutableEntry<String, String>(value, value));
    }

    @Test
    public void testTimeZone() throws IOException {
        MarshallingTester<TimeZone> tester = this.factory.createTester();
        tester.test(TimeZone.getDefault());
        tester.test(TimeZone.getTimeZone("GMT"));
    }

    @Test
    public void testTreeMap() throws IOException {
        MarshallingTester<TreeMap> tester = this.factory.createTester();
        TreeMap<Object, Object> map = new TreeMap<Object, Object>();
        map.putAll(BASIS);
        tester.test(map, AbstractUtilTestCase::assertMapEquals);
        map = new TreeMap(Comparator.reverseOrder());
        map.putAll(BASIS);
        tester.test(map, AbstractUtilTestCase::assertMapEquals);
        map = new TreeMap(new TestComparator());
        map.putAll(BASIS);
        tester.test(map, AbstractUtilTestCase::assertMapEquals);
    }

    @Test
    public void testTreeSet() throws IOException {
        MarshallingTester<TreeSet> tester = this.factory.createTester();
        TreeSet<Object> set = new TreeSet<Object>();
        set.addAll(BASIS.keySet());
        tester.test(set, AbstractUtilTestCase::assertCollectionEquals);
        set = new TreeSet(Comparator.reverseOrder());
        set.addAll(BASIS.keySet());
        tester.test(set, AbstractUtilTestCase::assertCollectionEquals);
        set = new TreeSet(new TestComparator());
        set.addAll(BASIS.keySet());
        tester.test(set, AbstractUtilTestCase::assertCollectionEquals);
    }

    @Test
    public void testUUID() throws IOException {
        MarshallingTester<UUID> tester = this.factory.createTester();
        tester.test(UUID.randomUUID());
    }

    @Test
    public void testEmptyList() throws IOException {
        MarshallingTester<List> tester = this.factory.createTester();
        tester.test(Collections.emptyList(), Assertions::assertSame);
    }

    @Test
    public void testEmptyMap() throws IOException {
        MarshallingTester<Map> tester = this.factory.createTester();
        tester.test(Collections.emptyMap(), Assertions::assertSame);
    }

    @Test
    public void testEmptyNavigableMap() throws IOException {
        MarshallingTester<NavigableMap> tester = this.factory.createTester();
        tester.test(Collections.emptyNavigableMap(), Assertions::assertSame);
    }

    @Test
    public void testEmptyNavigableSet() throws IOException {
        MarshallingTester<NavigableSet> tester = this.factory.createTester();
        tester.test(Collections.emptyNavigableSet(), Assertions::assertSame);
    }

    @Test
    public void testEmptySet() throws IOException {
        MarshallingTester<Set> tester = this.factory.createTester();
        tester.test(Collections.emptySet(), Assertions::assertSame);
    }

    @Test
    public void testEmptySortedMap() throws IOException {
        MarshallingTester<SortedMap> tester = this.factory.createTester();
        tester.test(Collections.emptySortedMap(), Assertions::assertSame);
    }

    @Test
    public void testEmptySortedSet() throws IOException {
        MarshallingTester<SortedSet> tester = this.factory.createTester();
        tester.test(Collections.emptySortedSet(), Assertions::assertSame);
    }

    @Test
    public void testSynchronizedCollection() throws IOException {
        MarshallingTester<Collection> tester = this.factory.createTester();
        tester.test(Collections.synchronizedCollection(new LinkedList<Object>(BASIS.keySet())), AbstractUtilTestCase::assertCollectionEquals);
    }

    @Test
    public void testSynchronizedList() throws IOException {
        MarshallingTester<List> tester = this.factory.createTester();
        tester.test(Collections.synchronizedList(new LinkedList<Object>(BASIS.keySet())), AbstractUtilTestCase::assertCollectionEquals);
    }

    @Test
    public void testSynchronizedMap() throws IOException {
        MarshallingTester<Map> tester = this.factory.createTester();
        tester.test(Collections.synchronizedMap(new HashMap<Object, Object>(BASIS)), AbstractUtilTestCase::assertMapEquals);
    }

    @Test
    public void testSynchronizedNavigableMap() throws IOException {
        MarshallingTester<Map> tester = this.factory.createTester();
        TreeMap<Object, Object> map = new TreeMap<Object, Object>();
        map.putAll(BASIS);
        tester.test(Collections.synchronizedNavigableMap(map), AbstractUtilTestCase::assertMapEquals);
    }

    @Test
    public void testSynchronizedNavigableSet() throws IOException {
        MarshallingTester<Set> tester = this.factory.createTester();
        TreeSet<Object> set = new TreeSet<Object>();
        set.addAll(BASIS.keySet());
        tester.test(Collections.synchronizedNavigableSet(set), AbstractUtilTestCase::assertCollectionEquals);
    }

    @Test
    public void testSynchronizedRandomAccessList() throws IOException {
        MarshallingTester<List> tester = this.factory.createTester();
        tester.test(Collections.synchronizedList(new ArrayList<Object>(BASIS.keySet())), AbstractUtilTestCase::assertCollectionEquals);
    }

    @Test
    public void testSynchronizedSet() throws IOException {
        MarshallingTester<Set> tester = this.factory.createTester();
        tester.test(Collections.synchronizedSet(new HashSet<Object>(BASIS.keySet())), AbstractUtilTestCase::assertCollectionEquals);
    }

    @Test
    public void testSynchronizedSortedMap() throws IOException {
        MarshallingTester<Map> tester = this.factory.createTester();
        TreeMap<Object, Object> map = new TreeMap<Object, Object>();
        map.putAll(BASIS);
        tester.test(Collections.synchronizedSortedMap(map), AbstractUtilTestCase::assertMapEquals);
    }

    @Test
    public void testSynchronizedSortedSet() throws IOException {
        MarshallingTester<Set> tester = this.factory.createTester();
        TreeSet<Object> set = new TreeSet<Object>();
        set.addAll(BASIS.keySet());
        tester.test(Collections.synchronizedSortedSet(set), AbstractUtilTestCase::assertCollectionEquals);
    }

    @Test
    public void testSingletonList() throws IOException {
        MarshallingTester<List> tester = this.factory.createTester();
        tester.test(Collections.singletonList(null), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(Collections.singletonList("foo"), AbstractUtilTestCase::assertCollectionEquals);
    }

    @Test
    public void testSingletonMap() throws IOException {
        MarshallingTester<Map> tester = this.factory.createTester();
        tester.test(Collections.singletonMap(null, null), AbstractUtilTestCase::assertMapEquals);
        tester.test(Collections.singletonMap("foo", null), AbstractUtilTestCase::assertMapEquals);
        tester.test(Collections.singletonMap("foo", "bar"), AbstractUtilTestCase::assertMapEquals);
    }

    @Test
    public void testSingletonSet() throws IOException {
        MarshallingTester<Set> tester = this.factory.createTester();
        tester.test(Collections.singleton(null), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(Collections.singleton("foo"), AbstractUtilTestCase::assertCollectionEquals);
    }

    @Test
    public void testUnmodifiableCollection() throws IOException {
        MarshallingTester<Collection> tester = this.factory.createTester();
        tester.test(Collections.synchronizedCollection(new LinkedList<Object>(BASIS.keySet())), AbstractUtilTestCase::assertCollectionEquals);
    }

    @Test
    public void testUnmodifiableList() throws IOException {
        MarshallingTester<List> tester = this.factory.createTester();
        tester.test(Collections.synchronizedList(new LinkedList<Object>(BASIS.keySet())), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(List.of(), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(List.of(Integer.valueOf(0)), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(List.of(Integer.valueOf(0), Integer.valueOf(1)), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5)), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6)), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7)), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7)), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8)), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8), Integer.valueOf(9)), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(List.of(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10), AbstractUtilTestCase::assertCollectionEquals);
    }

    @Test
    public void testUnmodifiableMap() throws IOException {
        MarshallingTester<Map> tester = this.factory.createTester();
        tester.test(Collections.synchronizedMap(new HashMap<Object, Object>(BASIS)), AbstractUtilTestCase::assertMapEquals);
        tester.test(Map.of(), AbstractUtilTestCase::assertMapEquals);
        tester.test(Map.of(0, "0"), AbstractUtilTestCase::assertMapEquals);
        tester.test(Map.of(0, "0", 1, "1"), AbstractUtilTestCase::assertMapEquals);
        tester.test(Map.of(0, "0", 1, "1", 2, "2"), AbstractUtilTestCase::assertMapEquals);
        tester.test(Map.of(0, "0", 1, "1", 2, "2", 3, "3"), AbstractUtilTestCase::assertMapEquals);
        tester.test(Map.of(0, "0", 1, "1", 2, "2", 3, "3", 4, "4"), AbstractUtilTestCase::assertMapEquals);
        tester.test(Map.of(0, "0", 1, "1", 2, "2", 3, "3", 4, "4", 5, "5"), AbstractUtilTestCase::assertMapEquals);
        tester.test(Map.of(0, "0", 1, "1", 2, "2", 3, "3", 4, "4", 5, "5", 6, "6"), AbstractUtilTestCase::assertMapEquals);
        tester.test(Map.of(0, "0", 1, "1", 2, "2", 3, "3", 4, "4", 5, "5", 6, "6", 7, "7"), AbstractUtilTestCase::assertMapEquals);
        tester.test(Map.of(0, "0", 1, "1", 2, "2", 3, "3", 4, "4", 5, "5", 6, "6", 7, "7", 8, "8"), AbstractUtilTestCase::assertMapEquals);
        tester.test(Map.of(0, "0", 1, "1", 2, "2", 3, "3", 4, "4", 5, "5", 6, "6", 7, "7", 8, "8", 9, "9"), AbstractUtilTestCase::assertMapEquals);
        tester.test(Map.ofEntries(Map.entry(0, "1")), AbstractUtilTestCase::assertMapEquals);
        tester.test(Map.ofEntries(Map.entry(0, "0"), Map.entry(1, "1")), AbstractUtilTestCase::assertMapEquals);
        tester.test(Map.ofEntries(Map.entry(0, "0"), Map.entry(1, "1"), Map.entry(2, "2")), AbstractUtilTestCase::assertMapEquals);
    }

    @Test
    public void testUnmodifiableNavigableMap() throws IOException {
        MarshallingTester<Map> tester = this.factory.createTester();
        TreeMap<Object, Object> map = new TreeMap<Object, Object>();
        map.putAll(BASIS);
        tester.test(Collections.synchronizedNavigableMap(map), AbstractUtilTestCase::assertMapEquals);
    }

    @Test
    public void testUnmodifiableNavigableSet() throws IOException {
        MarshallingTester<Set> tester = this.factory.createTester();
        TreeSet<Object> set = new TreeSet<Object>();
        set.addAll(BASIS.keySet());
        tester.test(Collections.synchronizedNavigableSet(set), AbstractUtilTestCase::assertCollectionEquals);
    }

    @Test
    public void testUnmodifiableRandomAccessList() throws IOException {
        MarshallingTester<List> tester = this.factory.createTester();
        tester.test(Collections.synchronizedList(new ArrayList<Object>(BASIS.keySet())), AbstractUtilTestCase::assertCollectionEquals);
    }

    @Test
    public void testUnmodifiableSet() throws IOException {
        MarshallingTester<Set> tester = this.factory.createTester();
        tester.test(Collections.synchronizedSet(new HashSet<Object>(BASIS.keySet())), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(Set.of(), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(Set.of(Integer.valueOf(0)), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(Set.of(Integer.valueOf(0), Integer.valueOf(1)), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5)), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6)), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7)), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7)), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8)), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8), Integer.valueOf(9)), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(Set.of(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10), AbstractUtilTestCase::assertCollectionEquals);
    }

    @Test
    public void testUnmodifiableSortedMap() throws IOException {
        MarshallingTester<Map> tester = this.factory.createTester();
        TreeMap<Object, Object> map = new TreeMap<Object, Object>();
        map.putAll(BASIS);
        tester.test(Collections.synchronizedSortedMap(map), AbstractUtilTestCase::assertMapEquals);
    }

    @Test
    public void testUnmodifiableSortedSet() throws IOException {
        MarshallingTester<Set> tester = this.factory.createTester();
        TreeSet<Object> set = new TreeSet<Object>();
        set.addAll(BASIS.keySet());
        tester.test(Collections.synchronizedSortedSet(set), AbstractUtilTestCase::assertCollectionEquals);
    }

    static <T extends Collection<?>> void assertCollectionEquals(T expected, T actual) {
        Assertions.assertSame(expected.getClass(), actual.getClass());
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        Assertions.assertTrue((boolean)expected.containsAll(actual));
    }

    static <T extends Map<?, ?>> void assertMapEquals(T expected, T actual) {
        Assertions.assertSame(expected.getClass(), actual.getClass());
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        Assertions.assertTrue((boolean)expected.keySet().containsAll(actual.keySet()), (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)(actual.keySet()));
        for (Map.Entry<?, ?> entry : expected.entrySet()) {
            Assertions.assertEquals(entry.getValue(), actual.get(entry.getKey()));
        }
    }

    static <T extends Map<?, ?>> void assertLinkedMapEquals(T expected, T actual) {
        Assertions.assertSame(expected.getClass(), actual.getClass());
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        expected.get(expected.keySet().iterator().next());
        actual.get(actual.keySet().iterator().next());
        Iterator<Map.Entry<?, ?>> expectedEntries = expected.entrySet().iterator();
        Iterator<Map.Entry<?, ?>> actualEntries = actual.entrySet().iterator();
        while (expectedEntries.hasNext() && actualEntries.hasNext()) {
            Map.Entry<?, ?> expectedEntry = expectedEntries.next();
            Map.Entry<?, ?> actualEntry = actualEntries.next();
            Assertions.assertEquals(expectedEntry.getKey(), actualEntry.getKey());
            Assertions.assertEquals(expectedEntry.getValue(), actualEntry.getValue());
        }
    }
}

