/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.BiConsumer;
import org.junit.jupiter.api.Assertions;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.TestMarshaller;
import org.wildfly.clustering.marshalling.Tester;

public class MarshallingTester<T>
implements Tester<T> {
    private final TestMarshaller<T> marshaller;
    private final List<ByteBufferMarshaller> benchmarkMarshallers;

    public MarshallingTester(TestMarshaller<T> marshaller, List<ByteBufferMarshaller> benchmarkMarshallers) {
        this.marshaller = marshaller;
        this.benchmarkMarshallers = benchmarkMarshallers;
    }

    @Override
    public void test(T subject, BiConsumer<T, T> assertion) throws IOException {
        ByteBuffer buffer = (ByteBuffer)this.marshaller.write(subject);
        int size = buffer.limit() - buffer.arrayOffset();
        if (subject != null) {
            // empty if block
        }
        Object result = this.marshaller.read(buffer);
        assertion.accept(subject, result);
        for (ByteBufferMarshaller benchmarkMarshaller : this.benchmarkMarshallers) {
            if (!benchmarkMarshaller.isMarshallable(subject)) continue;
            ByteBuffer serializationBuffer = benchmarkMarshaller.write(subject);
            int serializationSize = serializationBuffer.limit() - serializationBuffer.arrayOffset();
            Assertions.assertTrue((size < serializationSize ? 1 : 0) != 0, () -> String.format("Marshaller size = %d, %s serialization size = %d", size, benchmarkMarshaller.getClass().getSimpleName(), serializationSize));
        }
    }
}

