/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.OptionalInt;
import org.jboss.logging.Logger;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.IndexSerializer;
import org.wildfly.clustering.marshalling.MarshalledValue;

public class ByteBufferMarshalledValue<T>
implements MarshalledValue<T, ByteBufferMarshaller>,
Serializable {
    private static final long serialVersionUID = -8419893544424515905L;
    private static final Logger LOGGER = Logger.getLogger(ByteBufferMarshalledValue.class);
    private volatile transient ByteBufferMarshaller marshaller;
    private volatile transient T object;
    private volatile transient ByteBuffer buffer;

    public ByteBufferMarshalledValue(T object, ByteBufferMarshaller marshaller) {
        this.marshaller = marshaller;
        this.object = object;
    }

    public ByteBufferMarshalledValue(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    T peek() {
        return this.object;
    }

    public synchronized boolean isEmpty() {
        return this.buffer == null && this.object == null;
    }

    public synchronized ByteBuffer getBuffer() throws IOException {
        ByteBuffer buffer = this.buffer;
        if (buffer == null && this.object != null) {
            buffer = this.marshaller.write(this.object);
            LOGGER.debugf("Marshalled size of %s object = %d bytes", (Object)this.object.getClass().getCanonicalName(), (Object)(buffer.limit() - buffer.arrayOffset()));
        }
        return buffer;
    }

    public synchronized OptionalInt size() {
        return this.buffer != null ? OptionalInt.of(this.buffer.remaining()) : this.marshaller.size(this.object);
    }

    @Override
    public synchronized T get(ByteBufferMarshaller marshaller) throws IOException {
        if (this.object == null) {
            this.marshaller = marshaller;
            if (this.buffer != null) {
                this.object = this.marshaller.read(this.buffer);
                this.buffer = null;
            }
        }
        return this.object;
    }

    public int hashCode() {
        return Objects.hashCode(this.object);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ByteBufferMarshalledValue)) {
            return false;
        }
        ByteBufferMarshalledValue value = (ByteBufferMarshalledValue)object;
        T ourObject = this.object;
        T theirObject = value.object;
        if (ourObject != null && theirObject != null) {
            return ourObject.equals(theirObject);
        }
        try {
            ByteBuffer us = this.getBuffer();
            ByteBuffer them = value.getBuffer();
            return us != null && them != null ? us.equals(them) : us == them;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return String.format("%s [%s]", this.getClass().getName(), this.object != null ? this.object.getClass().getName() : "<serialized>");
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        ByteBuffer buffer = this.getBuffer();
        int length = buffer != null ? buffer.limit() - buffer.arrayOffset() : 0;
        IndexSerializer.VARIABLE.writeInt(output, length);
        if (length > 0) {
            output.write(buffer.array(), buffer.arrayOffset(), length);
        }
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        byte[] bytes;
        input.defaultReadObject();
        int size = IndexSerializer.VARIABLE.readInt(input);
        byte[] byArray = bytes = size > 0 ? new byte[size] : null;
        if (bytes != null) {
            input.readFully(bytes);
        }
        this.buffer = bytes != null ? ByteBuffer.wrap(bytes) : null;
    }
}

