/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Function;
import org.wildfly.clustering.marshalling.Serializer;

public class MappedSerializer<T, V>
implements Serializer<T> {
    private final Serializer<V> serializer;
    private final Function<T, V> accessor;
    private final Function<V, T> factory;

    public MappedSerializer(Serializer<V> serializer, Function<T, V> accessor, Function<V, T> factory) {
        this.serializer = serializer;
        this.accessor = accessor;
        this.factory = factory;
    }

    @Override
    public void write(DataOutput output, T value) throws IOException {
        this.serializer.write(output, this.accessor.apply(value));
    }

    @Override
    public T read(DataInput input) throws IOException {
        return this.factory.apply(this.serializer.read(input));
    }
}

