/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import org.junit.jupiter.api.Assertions;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.Tester;
import org.wildfly.clustering.marshalling.TesterFactory;

public interface MarshallingTesterFactory
extends TesterFactory {
    @Override
    default public <T> Tester<T> createTester(final BiConsumer<T, T> assertion) {
        final ByteBufferMarshaller marshaller = this.getMarshaller();
        return new Tester<T>(){

            @Override
            public void accept(T subject) {
                try {
                    Assertions.assertTrue((boolean)marshaller.isMarshallable(subject), () -> Optional.ofNullable(subject).map(Object::toString).orElse(null));
                    OptionalInt size = marshaller.size(subject);
                    ByteBuffer buffer = marshaller.write(subject);
                    int bufferSize = buffer.limit() - buffer.arrayOffset();
                    if (size.isPresent()) {
                        Assertions.assertEquals((int)size.getAsInt(), (int)bufferSize);
                    }
                    if (subject != null) {
                        Class<Object> subjectClass = subject instanceof Enum ? ((Enum)subject).getDeclaringClass() : subject.getClass();
                        Object subjectValue = subject instanceof Character ? Integer.valueOf(((Character)subject).charValue()) : subject;
                        System.out.println(String.format("%s\t%s\t%s\t%d", marshaller, subjectClass.getCanonicalName(), subjectValue, bufferSize));
                    }
                    Object result = marshaller.read(buffer);
                    assertion.accept(subject, result);
                }
                catch (IOException e) {
                    Assertions.fail((Throwable)e);
                }
            }

            @Override
            public void reject(T subject) {
                Assertions.assertFalse((boolean)marshaller.isMarshallable(subject), subject::toString);
            }

            @Override
            public <E extends Throwable> void reject(T subject, Class<E> expected) {
                Assertions.assertTrue((boolean)marshaller.isMarshallable(subject), subject::toString);
                try {
                    ByteBuffer buffer = marshaller.write(subject);
                    Assertions.assertThrows(expected, () -> marshaller.read(buffer), subject::toString);
                }
                catch (IOException e) {
                    Assertions.assertInstanceOf(expected, (Object)e);
                }
            }
        };
    }

    public ByteBufferMarshaller getMarshaller();
}

