/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.wildfly.clustering.marshalling.Tester;

public interface TesterFactory {
    public <T> Tester<T> createTester(BiConsumer<T, T> var1);

    default public <T, U> Tester<T> createTester(Function<T, U> mapper) {
        return this.createTester(TesterFactory.equalsAssertion(mapper));
    }

    default public <T> Tester<T> createTester() {
        return this.createTester(Assertions::assertEquals);
    }

    default public <T> Tester<T> createIdentityTester() {
        return this.createTester(Assertions::assertSame);
    }

    default public <T> Tester<T> createKeyTester() {
        BiConsumer<Object, Object> hashCode = TesterFactory.equalsAssertion(Object::hashCode);
        return this.createTester(hashCode.andThen(Assertions::assertEquals));
    }

    default public <E extends Enum<E>> Runnable createTester(Class<E> enumClass) {
        Tester tester = this.createIdentityTester();
        return () -> EnumSet.allOf(enumClass).forEach(tester::accept);
    }

    default public <E, T extends Collection<E>> Tester<T> createCollectionTester() {
        return this.createTester(TesterFactory::assertEquals);
    }

    default public <E, T extends Collection<E>> Tester<T> createOrderedCollectionTester() {
        return this.createTester(TesterFactory::assertOrderedEquals);
    }

    default public <K, V, T extends Map<K, V>> Tester<T> createMapTester() {
        return this.createTester(TesterFactory::assertEquals);
    }

    default public <K, V, T extends Map<K, V>> Tester<T> createOrderedMapTester() {
        return this.createTester(TesterFactory::assertOrderedEquals);
    }

    public static <T, R> BiConsumer<T, T> equalsAssertion(Function<T, R> mapper) {
        return (expected, actual) -> Assertions.assertEquals(mapper.apply(expected), mapper.apply(actual));
    }

    public static <E> void assertEquals(Collection<E> expected, Collection<E> actual) {
        TesterFactory.assertEquals(expected, actual, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)(actual));
    }

    public static <E> void assertEquals(Collection<E> expected, Collection<E> actual, Supplier<String> message) {
        Assertions.assertEquals((int)expected.size(), (int)actual.size(), message);
        Assertions.assertTrue((boolean)actual.containsAll(expected), message);
    }

    public static <K, V> void assertEquals(Map<K, V> expected, Map<K, V> actual) {
        TesterFactory.assertEquals(expected, actual, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)(actual));
    }

    public static <K, V> void assertEquals(Map<K, V> expected, Map<K, V> actual, Supplier<String> message) {
        TesterFactory.assertEquals(expected.keySet(), actual.keySet(), message);
        for (Map.Entry<K, V> entry : expected.entrySet()) {
            Assertions.assertEquals(entry.getValue(), actual.get(entry.getKey()), message);
        }
    }

    public static <E> void assertOrderedEquals(Collection<E> expected, Collection<E> actual) {
        TesterFactory.assertOrderedEquals(expected, actual, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)(actual));
    }

    public static <E> void assertOrderedEquals(Collection<E> expected, Collection<E> actual, Supplier<String> message) {
        TesterFactory.assertEquals(expected, actual, message);
        Iterator<E> expectedIterator = expected.iterator();
        Iterator<E> actualIterator = actual.iterator();
        while (expectedIterator.hasNext()) {
            Assertions.assertEquals(expectedIterator.next(), actualIterator.next());
        }
    }

    public static <K, V> void assertOrderedEquals(Map<K, V> expected, Map<K, V> actual) {
        TesterFactory.assertOrderedEquals(expected, actual, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)(actual));
    }

    public static <K, V> void assertOrderedEquals(Map<K, V> expected, Map<K, V> actual, Supplier<String> message) {
        TesterFactory.assertOrderedEquals(expected.keySet(), actual.keySet(), message);
        TesterFactory.assertEquals(expected, actual, message);
    }
}

