/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;
import org.wildfly.clustering.marshalling.Tester;

public abstract class AbstractNetTestCase {
    private final MarshallingTesterFactory factory;

    public AbstractNetTestCase(MarshallingTesterFactory factory) {
        this.factory = factory;
    }

    @Test
    public void testURI() {
        Tester<URI> tester = this.factory.createTester();
        tester.accept(URI.create("http://wildfly.org/news/"));
    }

    @Test
    public void testURL() throws MalformedURLException {
        Tester<URL> tester = this.factory.createTester();
        tester.accept(URI.create("http://wildfly.org/news/").toURL());
    }

    @Test
    public void testInetAddress() throws UnknownHostException {
        Tester<InetAddress> tester = this.factory.createTester();
        tester.accept(InetAddress.getLoopbackAddress());
        tester.accept(InetAddress.getLocalHost());
        tester.accept(InetAddress.getByName("127.0.0.1"));
        tester.accept(InetAddress.getByName("::1"));
        tester.accept(InetAddress.getByName("0.0.0.0"));
        tester.accept(InetAddress.getByName("::"));
    }

    @Test
    public void testInetSocketAddress() throws UnknownHostException {
        Tester<InetSocketAddress> tester = this.factory.createTester();
        tester.accept(InetSocketAddress.createUnresolved("foo.bar", 0));
        tester.accept(InetSocketAddress.createUnresolved("foo.bar", Short.MAX_VALUE));
        tester.accept(new InetSocketAddress(InetAddress.getLoopbackAddress(), 0));
        tester.accept(new InetSocketAddress(InetAddress.getLoopbackAddress(), Short.MAX_VALUE));
        tester.accept(new InetSocketAddress(InetAddress.getLocalHost(), 0));
        tester.accept(new InetSocketAddress(InetAddress.getLocalHost(), Short.MAX_VALUE));
        tester.accept(new InetSocketAddress(InetAddress.getByName("0.0.0.0"), 0));
        tester.accept(new InetSocketAddress(InetAddress.getByName("0.0.0.0"), Short.MAX_VALUE));
        tester.accept(new InetSocketAddress(InetAddress.getByName("::"), 0));
        tester.accept(new InetSocketAddress(InetAddress.getByName("::"), Short.MAX_VALUE));
    }
}

