/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.OptionalInt;
import org.assertj.core.api.Assertions;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.TestMarshaller;

public class ByteBufferTestMarshaller<T>
implements TestMarshaller<T> {
    private final ByteBufferMarshaller marshaller;

    public ByteBufferTestMarshaller(ByteBufferMarshaller marshaller) {
        this.marshaller = marshaller;
    }

    public T read(ByteBuffer buffer) throws IOException {
        return (T)this.marshaller.read(buffer);
    }

    public ByteBuffer write(T object) throws IOException {
        ByteBuffer buffer = this.marshaller.write(object);
        OptionalInt size = this.marshaller.size(object);
        if (size.isPresent()) {
            Assertions.assertThat((OptionalInt)size).isEqualTo((Object)buffer.remaining());
        }
        return buffer;
    }

    public boolean isMarshallable(Object object) {
        return this.marshaller.isMarshallable(object);
    }
}

