/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableTypeAssert;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.Tester;
import org.wildfly.clustering.marshalling.TesterFactory;

public interface MarshallingTesterFactory
extends TesterFactory {
    @Override
    default public <T> Tester<T> createTester(final BiConsumer<T, T> assertion) {
        final ByteBufferMarshaller marshaller = this.getMarshaller();
        return new Tester<T>(this){
            final /* synthetic */ MarshallingTesterFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void accept(T subject) {
                try {
                    ((AbstractBooleanAssert)Assertions.assertThat((boolean)marshaller.isMarshallable(subject)).as(() -> Optional.ofNullable(subject).map(Object::toString).orElse(null))).isTrue();
                    OptionalInt size = marshaller.size(subject);
                    ByteBuffer buffer = marshaller.write(subject);
                    int bufferSize = buffer.limit() - buffer.arrayOffset();
                    if (size.isPresent()) {
                        Assertions.assertThat((OptionalInt)size).hasValue(bufferSize);
                    }
                    if (subject != null) {
                        Class<Object> subjectClass = subject instanceof Enum ? ((Enum)subject).getDeclaringClass() : subject.getClass();
                        Object subjectValue = subject instanceof Character ? Integer.valueOf(((Character)subject).charValue()) : subject;
                        System.out.println(String.format("%s\t%s\t%s\t%d", marshaller, subjectClass.getCanonicalName(), subjectValue, bufferSize));
                    }
                    Object result = marshaller.read(buffer);
                    assertion.accept(subject, result);
                }
                catch (IOException e) {
                    Assertions.fail((Throwable)e);
                }
            }

            @Override
            public void reject(T subject) {
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)marshaller.isMarshallable(subject)).as(subject::toString)).isFalse();
            }

            @Override
            public <E extends Throwable> void reject(T subject, Class<E> expected) {
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)marshaller.isMarshallable(subject)).as(subject::toString)).isTrue();
                try {
                    ByteBuffer buffer = marshaller.write(subject);
                    ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(expected).as(subject::toString)).isThrownBy(() -> marshaller.read(buffer));
                }
                catch (IOException e) {
                    Assertions.assertThat((Throwable)e).isInstanceOf(expected);
                }
            }
        };
    }

    public ByteBufferMarshaller getMarshaller();
}

