/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;
import org.wildfly.clustering.marshalling.Tester;
import org.wildfly.clustering.marshalling.test.TestComparator;

public abstract class AbstractConcurrentTestCase {
    private static final Map<Object, Object> BASIS = Stream.of(1, 2, 3, 4, 5).collect(Collectors.toMap(i -> i, i -> Integer.toString(-i.intValue())));
    private final MarshallingTesterFactory factory;

    public AbstractConcurrentTestCase(MarshallingTesterFactory factory) {
        this.factory = factory;
    }

    @Test
    public void testConcurrentHashMap() {
        Tester<ConcurrentHashMap<Object, Object>> tester = this.factory.createMapTester();
        tester.accept(new ConcurrentHashMap<Object, Object>(BASIS));
    }

    @Test
    public void testConcurrentHashSet() {
        ConcurrentHashMap.KeySetView<Object, Boolean> keySetView = ConcurrentHashMap.newKeySet();
        keySetView.addAll((Collection<Object>)BASIS.keySet());
        Tester<ConcurrentHashMap.KeySetView<Object, Boolean>> tester = this.factory.createCollectionTester();
        tester.accept(keySetView);
    }

    @Test
    public void testConcurrentLinkedDeque() {
        Tester<ConcurrentLinkedDeque<Object>> tester = this.factory.createOrderedCollectionTester();
        tester.accept(new ConcurrentLinkedDeque<Object>(BASIS.keySet()));
    }

    @Test
    public void testConcurrentLinkedQueue() {
        Tester<ConcurrentLinkedQueue<Object>> tester = this.factory.createOrderedCollectionTester();
        tester.accept(new ConcurrentLinkedQueue<Object>(BASIS.keySet()));
    }

    @Test
    public void testConcurrentSkipListMap() {
        Tester tester = this.factory.createMapTester();
        ConcurrentSkipListMap<Object, Object> map = new ConcurrentSkipListMap<Object, Object>();
        map.putAll(BASIS);
        tester.accept(map);
        map = new ConcurrentSkipListMap(Comparator.reverseOrder());
        map.putAll(BASIS);
        tester.accept(map);
        map = new ConcurrentSkipListMap(new TestComparator());
        map.putAll(BASIS);
        tester.accept(map);
        tester.accept(new ConcurrentSkipListMap<Object, Object>(BASIS));
    }

    @Test
    public void testConcurrentSkipListSet() {
        Tester tester = this.factory.createCollectionTester();
        ConcurrentSkipListSet<Object> set = new ConcurrentSkipListSet<Object>();
        set.addAll(BASIS.keySet());
        tester.accept(set);
        set = new ConcurrentSkipListSet(Comparator.reverseOrder());
        set.addAll(BASIS.keySet());
        tester.accept(set);
        set = new ConcurrentSkipListSet(new TestComparator());
        set.addAll(BASIS.keySet());
        tester.accept(set);
    }

    @Test
    public void testCopyOnWriteArrayList() {
        Tester<CopyOnWriteArrayList<Object>> tester = this.factory.createCollectionTester();
        tester.accept(new CopyOnWriteArrayList<Object>(BASIS.keySet()));
    }

    @Test
    public void testCopyOnWriteArraySet() {
        Tester<CopyOnWriteArraySet<Object>> tester = this.factory.createCollectionTester();
        tester.accept(new CopyOnWriteArraySet<Object>(BASIS.keySet()));
    }

    @Test
    public void testTimeUnit() {
        this.factory.createTester(TimeUnit.class).run();
    }
}

