/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableTypeAssert;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.Tester;
import org.wildfly.clustering.marshalling.TesterFactory;

public interface MarshallingTesterFactory
extends TesterFactory {
    public static final System.Logger LOGGER = System.getLogger(MarshallingTesterFactory.class.getName());

    @Override
    default public <T> Tester<T> createTester(final BiConsumer<T, T> assertion) {
        final ByteBufferMarshaller marshaller = this.getMarshaller();
        return new Tester<T>(this){
            final /* synthetic */ MarshallingTesterFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public T apply(T subject) {
                try {
                    ((AbstractBooleanAssert)Assertions.assertThat((boolean)marshaller.test(subject)).as(() -> Optional.ofNullable(subject).map(Object::toString).orElse(null))).isTrue();
                    OptionalInt size = marshaller.size(subject);
                    ByteBuffer buffer = marshaller.write(subject);
                    int bufferSize = buffer.limit() - buffer.arrayOffset();
                    if (size.isPresent()) {
                        Assertions.assertThat((OptionalInt)size).hasValue(bufferSize);
                    }
                    if (subject != null) {
                        Object object;
                        Class<?> subjectClass;
                        if (subject instanceof Enum) {
                            Enum enumValue = (Enum)subject;
                            v0 = enumValue.getDeclaringClass();
                        } else {
                            v0 = subjectClass = subject.getClass();
                        }
                        if (subject instanceof Character) {
                            Character character = (Character)subject;
                            object = (int)character.charValue();
                        } else {
                            object = subject;
                        }
                        Object subjectValue = object;
                        LOGGER.log(System.Logger.Level.DEBUG, "{0}\t{1}\t{2}\t{3}", marshaller, subjectClass.getCanonicalName(), subjectValue, bufferSize);
                    }
                    Object result = marshaller.read(buffer);
                    assertion.accept(subject, result);
                    return result;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }

            @Override
            public void reject(T subject) {
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)marshaller.test(subject)).as(subject::toString)).isFalse();
            }

            @Override
            public <E extends Throwable> void reject(T subject, Class<E> expected) {
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)marshaller.test(subject)).as(subject::toString)).isTrue();
                try {
                    ByteBuffer buffer = marshaller.write(subject);
                    ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(expected).as(subject::toString)).isThrownBy(() -> marshaller.read(buffer));
                }
                catch (IOException e) {
                    Assertions.assertThat((Throwable)e).isInstanceOf(expected);
                }
            }
        };
    }

    public ByteBufferMarshaller getMarshaller();
}

