/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server;

import java.util.List;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.server.GroupMember;
import org.wildfly.clustering.server.GroupMembership;
import org.wildfly.clustering.server.GroupMembershipEvent;

public class GroupMembershipEventTestCase {
    @Test
    public void test() {
        GroupMember joined = (GroupMember)Mockito.mock(GroupMember.class);
        GroupMember left = (GroupMember)Mockito.mock(GroupMember.class);
        GroupMember existing = (GroupMember)Mockito.mock(GroupMember.class);
        final GroupMembership previous = (GroupMembership)Mockito.mock(GroupMembership.class);
        final GroupMembership current = (GroupMembership)Mockito.mock(GroupMembership.class);
        ((GroupMembership)Mockito.doReturn(List.of(left, existing)).when((Object)previous)).getMembers();
        ((GroupMembership)Mockito.doReturn(List.of(existing, joined)).when((Object)current)).getMembers();
        GroupMembershipEvent<GroupMember> event = new GroupMembershipEvent<GroupMember>(){

            public GroupMembership<GroupMember> getPreviousMembership() {
                return previous;
            }

            public GroupMembership<GroupMember> getCurrentMembership() {
                return current;
            }
        };
        Assertions.assertEquals(Set.of(joined), (Object)event.getJoiners());
        Assertions.assertEquals(Set.of(left), (Object)event.getLeavers());
    }
}

