/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.registry;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.wildfly.clustering.server.GroupMember;
import org.wildfly.clustering.server.registry.Registry;

public interface RegistryFactory<M extends GroupMember, K, V> {
    public Registry<M, K, V> createRegistry(Map.Entry<K, V> var1);

    public static <M extends GroupMember, K, V> RegistryFactory<M, K, V> singleton(final BiFunction<Map.Entry<K, V>, Runnable, Registry<M, K, V>> factory) {
        final AtomicReference reference = new AtomicReference();
        return new RegistryFactory<M, K, V>(){

            @Override
            public Registry<M, K, V> createRegistry(Map.Entry<K, V> entry) {
                if (!reference.compareAndSet(null, entry)) {
                    throw new IllegalStateException();
                }
                return (Registry)factory.apply(entry, () -> reference.set(null));
            }
        };
    }
}

