/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.provider;

import java.security.AccessController;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.context.Flag;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.jboss.logging.Logger;
import org.wildfly.clustering.cache.batch.Batcher;
import org.wildfly.clustering.cache.infinispan.batch.TransactionBatch;
import org.wildfly.clustering.cache.infinispan.embedded.distribution.Locality;
import org.wildfly.clustering.context.DefaultExecutorService;
import org.wildfly.clustering.context.ExecutorServiceFactory;
import org.wildfly.clustering.server.Registration;
import org.wildfly.clustering.server.infinispan.CacheContainerGroup;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMemberFactory;
import org.wildfly.clustering.server.infinispan.provider.AddressSetAddFunction;
import org.wildfly.clustering.server.infinispan.provider.AddressSetRemoveFunction;
import org.wildfly.clustering.server.infinispan.provider.CacheServiceProviderRegistryConfiguration;
import org.wildfly.clustering.server.infinispan.util.CacheInvoker;
import org.wildfly.clustering.server.local.provider.DefaultServiceProviderRegistration;
import org.wildfly.clustering.server.provider.ServiceProviderListener;
import org.wildfly.clustering.server.provider.ServiceProviderRegistration;
import org.wildfly.clustering.server.provider.ServiceProviderRegistry;
import org.wildfly.clustering.server.util.Invoker;
import org.wildfly.common.function.ExceptionRunnable;

@Listener(observation=Listener.Observation.POST)
public class CacheServiceProviderRegistry<T>
implements ServiceProviderRegistry<T, CacheContainerGroupMember>,
Registration {
    private static final Logger LOGGER = Logger.getLogger(CacheServiceProviderRegistry.class);
    private final Batcher<TransactionBatch> batcher;
    private final ConcurrentMap<T, Map.Entry<ServiceProviderListener<CacheContainerGroupMember>, ExecutorService>> listeners = new ConcurrentHashMap<T, Map.Entry<ServiceProviderListener<CacheContainerGroupMember>, ExecutorService>>();
    private final Cache<T, Set<Address>> cache;
    private final CacheContainerGroup group;
    private final Invoker invoker;
    private final Executor executor;

    public CacheServiceProviderRegistry(CacheServiceProviderRegistryConfiguration config) {
        this.group = config.getGroup();
        this.cache = config.getCache();
        this.batcher = config.getBatcher();
        this.executor = config.getBlockingManager().asExecutor(this.getClass().getName());
        this.cache.addListener((Object)this);
        this.invoker = CacheInvoker.retrying(this.cache);
    }

    public void close() {
        this.cache.removeListener((Object)this);
        for (Map.Entry entry : this.listeners.values()) {
            ExecutorService executor = (ExecutorService)entry.getValue();
            if (executor == null) continue;
            this.shutdown(executor);
        }
        this.listeners.clear();
    }

    private void shutdown(ExecutorService executor) {
        AccessController.doPrivileged(DefaultExecutorService.shutdown((ExecutorService)executor));
        try {
            executor.awaitTermination(this.cache.getCacheConfiguration().transaction().cacheStopTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public CacheContainerGroup getGroup() {
        return this.group;
    }

    public ServiceProviderRegistration<T, CacheContainerGroupMember> register(T service) {
        return this.register(service, null);
    }

    public ServiceProviderRegistration<T, CacheContainerGroupMember> register(T service, ServiceProviderListener<CacheContainerGroupMember> listener) {
        AbstractMap.SimpleEntry<ServiceProviderListener<CacheContainerGroupMember>, Object> newEntry = new AbstractMap.SimpleEntry<ServiceProviderListener<CacheContainerGroupMember>, Object>(listener, null);
        Map.Entry entry = this.listeners.computeIfAbsent(service, key -> {
            if (listener != null) {
                newEntry.setValue(new DefaultExecutorService(listener.getClass(), (Function)ExecutorServiceFactory.SINGLE_THREAD));
            }
            return newEntry;
        });
        if (entry != newEntry) {
            throw new IllegalArgumentException(service.toString());
        }
        this.invoker.invoke((ExceptionRunnable)new RegisterLocalServiceTask(service));
        Address localAddress = this.cache.getCacheManager().getAddress();
        return new DefaultServiceProviderRegistration((ServiceProviderRegistry)this, service, () -> {
            try (TransactionBatch batch = (TransactionBatch)this.batcher.createBatch();){
                this.cache.getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES).compute(service, (BiFunction)((Object)new AddressSetRemoveFunction(localAddress)));
            }
            finally {
                ExecutorService executor;
                Map.Entry oldEntry = (Map.Entry)this.listeners.remove(service);
                if (oldEntry != null && (executor = (ExecutorService)oldEntry.getValue()) != null) {
                    this.shutdown(executor);
                }
            }
        });
    }

    void registerLocal(T service) {
        Address localAddress = this.cache.getCacheManager().getAddress();
        try (TransactionBatch batch = (TransactionBatch)this.batcher.createBatch();){
            this.register(localAddress, service);
        }
    }

    void register(Address address, T service) {
        this.cache.getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES).compute(service, (BiFunction)((Object)new AddressSetAddFunction(address)));
    }

    public Set<CacheContainerGroupMember> getProviders(T service) {
        Set addresses = (Set)this.cache.get(service);
        return addresses != null ? this.map(addresses) : Set.of();
    }

    public Set<T> getServices() {
        return this.cache.keySet();
    }

    private Set<CacheContainerGroupMember> map(Set<Address> addresses) {
        return addresses.stream().map(arg_0 -> ((CacheContainerGroupMemberFactory)this.group.getGroupMemberFactory()).createGroupMember(arg_0)).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
    }

    @TopologyChanged
    public CompletionStage<Void> topologyChanged(TopologyChangedEvent<T, Set<Address>> event) {
        ConsistentHash previousHash = event.getWriteConsistentHashAtStart();
        List previousMembers = previousHash.getMembers();
        ConsistentHash hash = event.getWriteConsistentHashAtEnd();
        List members = hash.getMembers();
        if (!members.equals(previousMembers)) {
            Set localServices;
            Cache cache = event.getCache();
            Address localAddress = cache.getCacheManager().getAddress();
            HashSet leftMembers = new HashSet(previousMembers);
            leftMembers.removeAll(members);
            if (!leftMembers.isEmpty()) {
                Locality locality = Locality.forConsistentHash((Cache)cache, (ConsistentHash)hash);
                Iterator addresses = leftMembers.iterator();
                while (addresses.hasNext()) {
                    if (locality.isLocal(addresses.next())) continue;
                    addresses.remove();
                }
            }
            Set<Object> set = localServices = !previousMembers.contains(localAddress) ? this.listeners.keySet() : Collections.emptySet();
            if (!leftMembers.isEmpty() || !localServices.isEmpty()) {
                Batcher<TransactionBatch> batcher = this.batcher;
                Invoker invoker = this.invoker;
                this.executor.execute(() -> {
                    if (!leftMembers.isEmpty()) {
                        try (TransactionBatch batch = (TransactionBatch)batcher.createBatch();
                             CloseableIterator keys = cache.getAdvancedCache().withFlags(Flag.FORCE_WRITE_LOCK).keySet().iterator();){
                            while (keys.hasNext()) {
                                cache.getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES).compute(keys.next(), (BiFunction)((Object)new AddressSetRemoveFunction(leftMembers)));
                            }
                        }
                    }
                    if (!localServices.isEmpty()) {
                        for (Object localService : localServices) {
                            invoker.invoke((ExceptionRunnable)new RegisterLocalServiceTask(localService));
                        }
                    }
                });
            }
        }
        return CompletableFuture.completedStage(null);
    }

    @CacheEntryCreated
    @CacheEntryModified
    public CompletionStage<Void> modified(CacheEntryEvent<T, Set<Address>> event) {
        ServiceProviderListener listener;
        Map.Entry entry = (Map.Entry)this.listeners.get(event.getKey());
        if (entry != null && (listener = (ServiceProviderListener)entry.getKey()) != null) {
            Executor executor = (Executor)entry.getValue();
            Set<CacheContainerGroupMember> members = this.map((Set)event.getValue());
            try {
                executor.execute(() -> {
                    try {
                        listener.providersChanged(members);
                    }
                    catch (Throwable e) {
                        LOGGER.warn((Object)e.getLocalizedMessage(), e);
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
        return CompletableFuture.completedStage(null);
    }

    private class RegisterLocalServiceTask
    implements ExceptionRunnable<CacheException> {
        private final T localService;

        RegisterLocalServiceTask(T localService) {
            this.localService = localService;
        }

        public void run() {
            CacheServiceProviderRegistry.this.registerLocal(this.localService);
        }
    }
}

