/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.remoting.transport.jgroups.JGroupsChannelConfigurator;
import org.jgroups.ChannelListener;
import org.jgroups.JChannel;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.util.SocketFactory;
import org.wildfly.clustering.cache.infinispan.marshalling.MediaTypes;
import org.wildfly.clustering.cache.infinispan.marshalling.UserMarshaller;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.ClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.SerializationContextBuilder;

public class EmbeddedCacheManagerFactory
implements BiFunction<String, ClassLoader, EmbeddedCacheManager> {
    private final Function<String, JChannel> factory;
    private final String clusterName;
    private final String memberName;

    public EmbeddedCacheManagerFactory(Function<String, JChannel> factory, String clusterName, String memberName) {
        this.factory = factory;
        this.clusterName = clusterName;
        this.memberName = memberName;
    }

    @Override
    public EmbeddedCacheManager apply(final String name, ClassLoader loader) {
        UserMarshaller marshaller = new UserMarshaller((Supplier)MediaTypes.WILDFLY_PROTOSTREAM, (ByteBufferMarshaller)new ProtoStreamByteBufferMarshaller((ImmutableSerializationContext)((SerializationContextBuilder)SerializationContextBuilder.newInstance((ClassLoaderMarshaller)ClassLoaderMarshaller.of((ClassLoader)loader)).load(loader)).build()));
        JGroupsChannelConfigurator configurator = new JGroupsChannelConfigurator(){

            public String getProtocolStackString() {
                return null;
            }

            public List<ProtocolConfiguration> getProtocolStack() {
                return null;
            }

            public String getName() {
                return name;
            }

            public JChannel createChannel(String ignored) throws Exception {
                return EmbeddedCacheManagerFactory.this.factory.apply(name);
            }

            public void setSocketFactory(SocketFactory socketFactory) {
            }

            public void addChannelListener(ChannelListener listener) {
            }
        };
        try {
            GlobalConfiguration global = new GlobalConfigurationBuilder().cacheManagerName(name).classLoader(loader).transport().defaultTransport().clusterName(this.clusterName).nodeName(this.memberName).addProperty("channelConfigurator", (Object)configurator).serialization().marshaller((Marshaller)marshaller).addContextInitializer(new SerializationContextInitializer(){

                @Deprecated
                public String getProtoFile() {
                    return null;
                }

                @Deprecated
                public String getProtoFileName() {
                    return null;
                }

                public void registerMarshallers(SerializationContext context) {
                }

                public void registerSchema(SerializationContext context) {
                }
            }).globalState().configurationStorage(ConfigurationStorage.VOLATILE).persistentLocation(Files.createTempDirectory(name, new FileAttribute[0]).toString(), name).temporaryLocation(Files.createTempDirectory(name, new FileAttribute[0]).toString(), name).build();
            return new DefaultCacheManager(global);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

