/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.provider;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;
import org.wildfly.clustering.server.infinispan.provider.CacheContainerServiceProviderRegistrar;
import org.wildfly.clustering.server.infinispan.provider.CacheContainerServiceProviderRegistrarProvider;
import org.wildfly.clustering.server.provider.ServiceProviderListener;
import org.wildfly.clustering.server.provider.ServiceProviderRegistration;

public class CacheServiceProviderRegistrarITCase {
    private static final String CLUSTER_NAME = "cluster";
    private static final String MEMBER_1 = "member1";
    private static final String MEMBER_2 = "member2";

    @Test
    public void test() throws Exception {
        String foo = "foo";
        String bar = "bar";
        try (CacheContainerServiceProviderRegistrarProvider provider1 = new CacheContainerServiceProviderRegistrarProvider(CLUSTER_NAME, MEMBER_1);){
            CacheContainerServiceProviderRegistrar registrar1 = provider1.get();
            CacheContainerGroupMember member1 = (CacheContainerGroupMember)registrar1.getGroup().getLocalMember();
            Assertions.assertEquals(Set.of(), (Object)registrar1.getServices());
            Assertions.assertEquals(Set.of(), (Object)registrar1.getProviders((Object)foo));
            Assertions.assertEquals(Set.of(), (Object)registrar1.getProviders((Object)bar));
            LinkedBlockingQueue<Set<CacheContainerGroupMember>> fooEvents = new LinkedBlockingQueue<Set<CacheContainerGroupMember>>();
            try (ServiceProviderRegistration fooRegistration1 = registrar1.register((Object)foo, (ServiceProviderListener)new CollectionServiceProviderListener(fooEvents));){
                Assertions.assertSame((Object)foo, (Object)fooRegistration1.getService());
                Assertions.assertEquals(Set.of(member1), (Object)fooRegistration1.getProviders());
                Assertions.assertEquals(Set.of(foo), (Object)registrar1.getServices());
                Assertions.assertEquals(Set.of(member1), (Object)registrar1.getProviders((Object)foo));
                Assertions.assertEquals(Set.of(member1), fooEvents.poll(5L, TimeUnit.SECONDS));
                LinkedBlockingQueue<Set<CacheContainerGroupMember>> barEvents = new LinkedBlockingQueue<Set<CacheContainerGroupMember>>();
                try (ServiceProviderRegistration barRegistration1 = registrar1.register((Object)bar, (ServiceProviderListener)new CollectionServiceProviderListener(barEvents));){
                    Assertions.assertSame((Object)bar, (Object)barRegistration1.getService());
                    Assertions.assertEquals(Set.of(member1), (Object)barRegistration1.getProviders());
                    Assertions.assertEquals(Set.of(foo, bar), (Object)registrar1.getServices());
                    Assertions.assertEquals(Set.of(member1), (Object)registrar1.getProviders((Object)bar));
                    Assertions.assertEquals(Set.of(member1), barEvents.poll(5L, TimeUnit.SECONDS));
                    try (CacheContainerServiceProviderRegistrarProvider provider2 = new CacheContainerServiceProviderRegistrarProvider(CLUSTER_NAME, MEMBER_2);){
                        CacheContainerServiceProviderRegistrar registrar2 = provider2.get();
                        CacheContainerGroupMember member2 = (CacheContainerGroupMember)registrar2.getGroup().getLocalMember();
                        Assertions.assertEquals(Set.of(foo, bar), (Object)registrar2.getServices());
                        Assertions.assertEquals(Set.of(member1), (Object)registrar2.getProviders((Object)foo));
                        Assertions.assertEquals(Set.of(member1), (Object)registrar2.getProviders((Object)bar));
                        try (ServiceProviderRegistration fooRegistration2 = registrar2.register((Object)foo);){
                            Assertions.assertSame((Object)foo, (Object)fooRegistration2.getService());
                            Assertions.assertEquals(Set.of(member1, member2), (Object)fooRegistration2.getProviders());
                            Assertions.assertEquals(Set.of(member1, member2), (Object)registrar1.getProviders((Object)foo));
                            Assertions.assertEquals(Set.of(member1, member2), (Object)registrar2.getProviders((Object)foo));
                            Assertions.assertEquals(Set.of(member1, member2), fooEvents.poll(5L, TimeUnit.SECONDS));
                        }
                        Assertions.assertEquals(Set.of(member1), fooEvents.poll(5L, TimeUnit.SECONDS));
                        ServiceProviderRegistration barRegistration2 = registrar2.register((Object)bar);
                        Assertions.assertSame((Object)bar, (Object)barRegistration2.getService());
                        Assertions.assertEquals(Set.of(member1, member2), (Object)barRegistration2.getProviders());
                        Assertions.assertEquals(Set.of(member1, member2), (Object)registrar1.getProviders((Object)bar));
                        Assertions.assertEquals(Set.of(member1, member2), (Object)registrar2.getProviders((Object)bar));
                        Assertions.assertEquals(Set.of(member1, member2), barEvents.poll(5L, TimeUnit.SECONDS));
                    }
                    Assertions.assertNull(fooEvents.poll(100L, TimeUnit.MILLISECONDS));
                    Assertions.assertEquals(Set.of(foo, bar), (Object)registrar1.getServices());
                    Assertions.assertEquals(Set.of(member1), (Object)registrar1.getProviders((Object)foo));
                    Assertions.assertEquals(Set.of(member1), (Object)registrar1.getProviders((Object)bar));
                    Assertions.assertEquals(Set.of(member1), barEvents.poll(5L, TimeUnit.SECONDS));
                }
                Assertions.assertEquals(Set.of(foo), (Object)registrar1.getServices());
                Assertions.assertEquals(Set.of(member1), (Object)registrar1.getProviders((Object)foo));
                Assertions.assertEquals(Set.of(), (Object)registrar1.getProviders((Object)bar));
                Assertions.assertNull(barEvents.poll(100L, TimeUnit.MILLISECONDS));
            }
            Assertions.assertEquals(Set.of(), (Object)registrar1.getServices());
            Assertions.assertEquals(Set.of(), (Object)registrar1.getProviders((Object)foo));
            Assertions.assertEquals(Set.of(), (Object)registrar1.getProviders((Object)bar));
            Assertions.assertNull(fooEvents.poll(100L, TimeUnit.MILLISECONDS));
        }
    }

    private static class CollectionServiceProviderListener
    implements ServiceProviderListener<CacheContainerGroupMember> {
        private final Collection<Set<CacheContainerGroupMember>> events;

        CollectionServiceProviderListener(Collection<Set<CacheContainerGroupMember>> events) {
            this.events = events;
        }

        public void providersChanged(Set<CacheContainerGroupMember> providers) {
            this.events.add(providers);
        }
    }
}

