/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.scheduler;

import java.time.Instant;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.wildfly.clustering.cache.infinispan.CacheKey;
import org.wildfly.clustering.cache.infinispan.embedded.distribution.Locality;
import org.wildfly.clustering.server.infinispan.scheduler.CacheEntryScheduler;
import org.wildfly.clustering.server.scheduler.Scheduler;

public abstract class AbstractCacheEntryScheduler<I, M>
implements CacheEntryScheduler<I, M> {
    private final Scheduler<I, Instant> scheduler;
    private final Function<M, Optional<Instant>> instant;

    protected AbstractCacheEntryScheduler(Scheduler<I, Instant> scheduler, Function<M, Optional<Instant>> instant) {
        this.scheduler = scheduler;
        this.instant = instant;
    }

    public void schedule(I id, M metaData) {
        Optional<Instant> instant = this.instant.apply(metaData);
        if (instant.isPresent()) {
            this.scheduler.schedule(id, (Object)instant.get());
        }
    }

    public void cancel(I id) {
        this.scheduler.cancel(id);
    }

    @Override
    public void cancel(Locality locality) {
        try (Stream stream = this.scheduler.stream();){
            Iterator entries = stream.iterator();
            while (entries.hasNext()) {
                if (Thread.currentThread().isInterrupted()) {
                    break;
                }
                Object id = entries.next();
                CacheKey key = new CacheKey(id);
                if (locality.isLocal((Object)key)) continue;
                this.scheduler.cancel(id);
            }
        }
    }

    public Stream<I> stream() {
        return this.scheduler.stream();
    }

    public void close() {
        this.scheduler.close();
    }

    public String toString() {
        return this.scheduler.toString();
    }
}

