/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.registry;

import java.util.Map;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.server.GroupMember;
import org.wildfly.clustering.server.Registration;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;
import org.wildfly.clustering.server.infinispan.registry.CacheContainerRegistryProvider;
import org.wildfly.clustering.server.registry.Registry;
import org.wildfly.clustering.server.registry.RegistryListener;

public class CacheRegistryITCase {
    private static final String CLUSTER_NAME = "cluster";
    private static final String MEMBER_1 = "member1";
    private static final String MEMBER_2 = "member2";

    @Test
    public void test() throws Exception {
        Map.Entry<String, UUID> entry1 = Map.entry("foo", UUID.randomUUID());
        Map.Entry<String, UUID> entry2 = Map.entry("bar", UUID.randomUUID());
        try (CacheContainerRegistryProvider provider1 = new CacheContainerRegistryProvider(CLUSTER_NAME, MEMBER_1);
             Registry<CacheContainerGroupMember, String, UUID> registry1 = provider1.apply(entry1);){
            CacheContainerGroupMember member1 = (CacheContainerGroupMember)registry1.getGroup().getLocalMember();
            Assertions.assertEquals(entry1, (Object)registry1.getEntry((GroupMember)member1));
            Assertions.assertEquals(Map.ofEntries(entry1), (Object)registry1.getEntries());
            RegistryListener listener = (RegistryListener)Mockito.mock(RegistryListener.class);
            try (Registration registration = registry1.register((Object)listener);){
                Mockito.verifyNoInteractions((Object[])new Object[]{listener});
                try (CacheContainerRegistryProvider provider2 = new CacheContainerRegistryProvider(CLUSTER_NAME, MEMBER_2);
                     Registry<CacheContainerGroupMember, String, UUID> registry2 = provider2.apply(entry2);){
                    CacheContainerGroupMember member2 = (CacheContainerGroupMember)registry2.getGroup().getLocalMember();
                    Assertions.assertEquals(entry1, (Object)registry1.getEntry((GroupMember)member1));
                    Assertions.assertEquals(entry1, (Object)registry2.getEntry((GroupMember)member1));
                    Assertions.assertEquals(entry2, (Object)registry1.getEntry((GroupMember)member2));
                    Assertions.assertEquals(entry2, (Object)registry2.getEntry((GroupMember)member2));
                    Assertions.assertEquals(Map.ofEntries(entry1, entry2), (Object)registry1.getEntries());
                    Assertions.assertEquals(Map.ofEntries(entry1, entry2), (Object)registry2.getEntries());
                    Thread.sleep(100L);
                    ((RegistryListener)Mockito.verify((Object)listener)).added(Map.ofEntries(entry2));
                    Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
                }
                Assertions.assertEquals(entry1, (Object)registry1.getEntry((GroupMember)member1));
                Assertions.assertEquals(Map.ofEntries(entry1), (Object)registry1.getEntries());
                Thread.sleep(100L);
                ((RegistryListener)Mockito.verify((Object)listener)).removed(Map.ofEntries(entry2));
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
            }
        }
    }
}

