/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan;

import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.jgroups.Address;
import org.jgroups.util.NameCache;
import org.jgroups.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.wildfly.clustering.cache.infinispan.embedded.persistence.FormatterTesterFactory;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;
import org.wildfly.clustering.marshalling.TesterFactory;
import org.wildfly.clustering.marshalling.junit.TesterFactorySource;
import org.wildfly.clustering.server.infinispan.EmbeddedCacheManagerGroupMember;
import org.wildfly.clustering.server.infinispan.LocalEmbeddedCacheManagerGroupMember;
import org.wildfly.clustering.server.jgroups.JChannelGroupMember;
import org.wildfly.clustering.server.local.LocalGroupMember;

public class EmbeddedCacheManagerGroupMemberTestCase {
    @ParameterizedTest
    @TesterFactorySource(value={MarshallingTesterFactory.class, FormatterTesterFactory.class})
    public void test(TesterFactory factory) {
        factory.createTester().accept((Object)new EmbeddedCacheManagerGroupMember(new JGroupsAddress((Address)UUID.randomUUID())));
    }

    @Test
    public void test() {
        UUID fooAddress = UUID.randomUUID();
        UUID barAddress = UUID.randomUUID();
        NameCache.add((Address)fooAddress, (String)"foo");
        NameCache.add((Address)barAddress, (String)"bar");
        EmbeddedCacheManagerGroupMember fooMember = new EmbeddedCacheManagerGroupMember(new JGroupsAddress((Address)fooAddress));
        Assertions.assertEquals((Object)"foo", (Object)fooMember.getName());
        EmbeddedCacheManagerGroupMember barMember = new EmbeddedCacheManagerGroupMember(new JGroupsAddress((Address)barAddress));
        Assertions.assertEquals((Object)"bar", (Object)barMember.getName());
        Assertions.assertEquals((Object)fooMember, (Object)new EmbeddedCacheManagerGroupMember(new JGroupsAddress((Address)fooAddress)));
        Assertions.assertEquals((int)fooMember.hashCode(), (int)new EmbeddedCacheManagerGroupMember(new JGroupsAddress((Address)fooAddress)).hashCode());
        Assertions.assertNotEquals((Object)fooMember, (Object)barMember);
        Assertions.assertEquals((Object)fooMember, (Object)new JChannelGroupMember((Address)fooAddress));
        Assertions.assertEquals((int)fooMember.hashCode(), (int)new JChannelGroupMember((Address)fooAddress).hashCode());
        Assertions.assertNotEquals((Object)fooMember, (Object)new JChannelGroupMember((Address)barAddress));
        Assertions.assertNotEquals((Object)fooMember, (Object)new LocalEmbeddedCacheManagerGroupMember("foo"));
        Assertions.assertNotEquals((Object)barMember, (Object)new LocalEmbeddedCacheManagerGroupMember("bar"));
        Assertions.assertNotEquals((Object)fooMember, (Object)LocalGroupMember.of((String)"foo"));
        Assertions.assertNotEquals((Object)barMember, (Object)LocalGroupMember.of((String)"bar"));
    }
}

