/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.provider;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;
import org.wildfly.clustering.server.infinispan.provider.CacheContainerServiceProviderRegistrar;
import org.wildfly.clustering.server.infinispan.provider.CacheContainerServiceProviderRegistrarProvider;
import org.wildfly.clustering.server.provider.ServiceProviderListener;
import org.wildfly.clustering.server.provider.ServiceProviderRegistration;

public class CacheServiceProviderRegistrarITCase {
    private static final String CLUSTER_NAME = "cluster";
    private static final String MEMBER_1 = "member1";
    private static final String MEMBER_2 = "member2";

    @Test
    public void test() throws Exception {
        String foo = "foo";
        String bar = "bar";
        try (CacheContainerServiceProviderRegistrarProvider provider1 = new CacheContainerServiceProviderRegistrarProvider(CLUSTER_NAME, MEMBER_1);){
            CacheContainerServiceProviderRegistrar registrar1 = provider1.get();
            CacheContainerGroupMember member1 = (CacheContainerGroupMember)registrar1.getGroup().getLocalMember();
            Assertions.assertThat((Collection)registrar1.getServices()).isEmpty();
            Assertions.assertThat((Collection)registrar1.getProviders((Object)foo)).isEmpty();
            Assertions.assertThat((Collection)registrar1.getProviders((Object)bar)).isEmpty();
            LinkedBlockingQueue<Set<CacheContainerGroupMember>> fooEvents = new LinkedBlockingQueue<Set<CacheContainerGroupMember>>();
            try (ServiceProviderRegistration fooRegistration1 = registrar1.register((Object)foo, (ServiceProviderListener)new CollectionServiceProviderListener(fooEvents));){
                Assertions.assertThat((String)((String)fooRegistration1.getService())).isSameAs((Object)foo);
                Assertions.assertThat((Collection)fooRegistration1.getProviders()).containsExactly((Object[])new CacheContainerGroupMember[]{member1});
                Assertions.assertThat((Collection)registrar1.getServices()).containsExactly((Object[])new String[]{foo});
                Assertions.assertThat((Collection)registrar1.getProviders((Object)foo)).containsExactly((Object[])new CacheContainerGroupMember[]{member1});
                Assertions.assertThat((Collection)((Collection)fooEvents.poll(5L, TimeUnit.SECONDS))).containsExactly((Object[])new CacheContainerGroupMember[]{member1});
                LinkedBlockingQueue<Set<CacheContainerGroupMember>> barEvents = new LinkedBlockingQueue<Set<CacheContainerGroupMember>>();
                try (ServiceProviderRegistration barRegistration1 = registrar1.register((Object)bar, (ServiceProviderListener)new CollectionServiceProviderListener(barEvents));){
                    Assertions.assertThat((String)((String)barRegistration1.getService())).isSameAs((Object)bar);
                    Assertions.assertThat((Collection)barRegistration1.getProviders()).containsExactly((Object[])new CacheContainerGroupMember[]{member1});
                    Assertions.assertThat((Collection)registrar1.getServices()).containsExactlyInAnyOrder((Object[])new String[]{foo, bar});
                    Assertions.assertThat((Collection)registrar1.getProviders((Object)bar)).containsExactly((Object[])new CacheContainerGroupMember[]{member1});
                    Assertions.assertThat((Collection)((Collection)barEvents.poll(5L, TimeUnit.SECONDS))).containsExactly((Object[])new CacheContainerGroupMember[]{member1});
                    try (CacheContainerServiceProviderRegistrarProvider provider2 = new CacheContainerServiceProviderRegistrarProvider(CLUSTER_NAME, MEMBER_2);){
                        CacheContainerServiceProviderRegistrar registrar2 = provider2.get();
                        CacheContainerGroupMember member2 = (CacheContainerGroupMember)registrar2.getGroup().getLocalMember();
                        Assertions.assertThat((Collection)registrar2.getServices()).containsExactlyInAnyOrder((Object[])new String[]{foo, bar});
                        Assertions.assertThat((Collection)registrar2.getProviders((Object)foo)).containsExactly((Object[])new CacheContainerGroupMember[]{member1});
                        Assertions.assertThat((Collection)registrar2.getProviders((Object)bar)).containsExactly((Object[])new CacheContainerGroupMember[]{member1});
                        try (ServiceProviderRegistration fooRegistration2 = registrar2.register((Object)foo);){
                            Assertions.assertThat((String)((String)fooRegistration2.getService())).isSameAs((Object)foo);
                            Assertions.assertThat((Collection)fooRegistration2.getProviders()).containsExactlyInAnyOrder((Object[])new CacheContainerGroupMember[]{member1, member2});
                            Assertions.assertThat((Collection)registrar1.getProviders((Object)foo)).containsExactlyInAnyOrder((Object[])new CacheContainerGroupMember[]{member1, member2});
                            Assertions.assertThat((Collection)registrar2.getProviders((Object)foo)).containsExactlyInAnyOrder((Object[])new CacheContainerGroupMember[]{member1, member2});
                            Assertions.assertThat((Collection)((Collection)fooEvents.poll(5L, TimeUnit.SECONDS))).containsExactlyInAnyOrder((Object[])new CacheContainerGroupMember[]{member1, member2});
                        }
                        Assertions.assertThat((Collection)((Collection)fooEvents.poll(5L, TimeUnit.SECONDS))).containsExactly((Object[])new CacheContainerGroupMember[]{member1});
                        ServiceProviderRegistration barRegistration2 = registrar2.register((Object)bar);
                        Assertions.assertThat((String)((String)barRegistration2.getService())).isSameAs((Object)bar);
                        Assertions.assertThat((Collection)barRegistration2.getProviders()).containsExactlyInAnyOrder((Object[])new CacheContainerGroupMember[]{member1, member2});
                        Assertions.assertThat((Collection)registrar1.getProviders((Object)bar)).containsExactlyInAnyOrder((Object[])new CacheContainerGroupMember[]{member1, member2});
                        Assertions.assertThat((Collection)registrar2.getProviders((Object)bar)).containsExactlyInAnyOrder((Object[])new CacheContainerGroupMember[]{member1, member2});
                        Assertions.assertThat((Collection)((Collection)barEvents.poll(5L, TimeUnit.SECONDS))).containsExactlyInAnyOrder((Object[])new CacheContainerGroupMember[]{member1, member2});
                    }
                    Assertions.assertThat((Collection)((Collection)fooEvents.poll(100L, TimeUnit.MILLISECONDS))).isNull();
                    Assertions.assertThat((Collection)registrar1.getServices()).containsExactlyInAnyOrder((Object[])new String[]{foo, bar});
                    Assertions.assertThat((Collection)registrar1.getProviders((Object)foo)).containsExactly((Object[])new CacheContainerGroupMember[]{member1});
                    Assertions.assertThat((Collection)registrar1.getProviders((Object)bar)).containsExactly((Object[])new CacheContainerGroupMember[]{member1});
                    Assertions.assertThat((Collection)((Collection)barEvents.poll(5L, TimeUnit.SECONDS))).containsExactly((Object[])new CacheContainerGroupMember[]{member1});
                }
                Assertions.assertThat((Collection)registrar1.getServices()).containsExactly((Object[])new String[]{foo});
                Assertions.assertThat((Collection)registrar1.getProviders((Object)foo)).containsExactly((Object[])new CacheContainerGroupMember[]{member1});
                Assertions.assertThat((Collection)registrar1.getProviders((Object)bar)).isEmpty();
                Assertions.assertThat((Collection)((Collection)barEvents.poll(100L, TimeUnit.MILLISECONDS))).isNull();
            }
            Assertions.assertThat((Collection)registrar1.getServices()).isEmpty();
            Assertions.assertThat((Collection)registrar1.getProviders((Object)foo)).isEmpty();
            Assertions.assertThat((Collection)registrar1.getProviders((Object)bar)).isEmpty();
            Assertions.assertThat((Collection)((Collection)fooEvents.poll(100L, TimeUnit.MILLISECONDS))).isNull();
        }
    }

    private static class CollectionServiceProviderListener
    implements ServiceProviderListener<CacheContainerGroupMember> {
        private final Collection<Set<CacheContainerGroupMember>> events;

        CollectionServiceProviderListener(Collection<Set<CacheContainerGroupMember>> events) {
            this.events = events;
        }

        public void providersChanged(Set<CacheContainerGroupMember> providers) {
            this.events.add(providers);
        }
    }
}

