/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan;

import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.jgroups.Address;
import org.jgroups.util.NameCache;
import org.jgroups.util.UUID;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.wildfly.clustering.cache.infinispan.embedded.persistence.FormatterTesterFactory;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;
import org.wildfly.clustering.marshalling.TesterFactory;
import org.wildfly.clustering.marshalling.junit.TesterFactorySource;
import org.wildfly.clustering.server.infinispan.EmbeddedCacheManagerGroupMember;
import org.wildfly.clustering.server.infinispan.LocalEmbeddedCacheManagerGroupMember;
import org.wildfly.clustering.server.jgroups.JChannelGroupMember;
import org.wildfly.clustering.server.local.LocalGroupMember;

public class EmbeddedCacheManagerGroupMemberTestCase {
    @ParameterizedTest
    @TesterFactorySource(value={MarshallingTesterFactory.class, FormatterTesterFactory.class})
    public void test(TesterFactory factory) {
        factory.createTester().accept((Object)new EmbeddedCacheManagerGroupMember(new JGroupsAddress((Address)UUID.randomUUID())));
    }

    @Test
    public void test() {
        UUID fooAddress = UUID.randomUUID();
        UUID barAddress = UUID.randomUUID();
        NameCache.add((Address)fooAddress, (String)"foo");
        NameCache.add((Address)barAddress, (String)"bar");
        EmbeddedCacheManagerGroupMember fooMember = new EmbeddedCacheManagerGroupMember(new JGroupsAddress((Address)fooAddress));
        Assertions.assertThat((String)fooMember.getName()).isEqualTo("foo");
        EmbeddedCacheManagerGroupMember barMember = new EmbeddedCacheManagerGroupMember(new JGroupsAddress((Address)barAddress));
        Assertions.assertThat((String)barMember.getName()).isEqualTo("bar");
        ((AbstractComparableAssert)((AbstractComparableAssert)((AbstractComparableAssert)((AbstractComparableAssert)Assertions.assertThat((Comparable)fooMember).hasSameHashCodeAs((Object)fooAddress)).isEqualTo((Object)new JChannelGroupMember((Address)fooAddress))).isNotEqualTo((Object)new JChannelGroupMember((Address)barAddress))).isNotEqualTo((Object)new LocalEmbeddedCacheManagerGroupMember("foo"))).isNotEqualTo((Object)LocalGroupMember.of((String)"foo"));
        ((AbstractComparableAssert)((AbstractComparableAssert)((AbstractComparableAssert)((AbstractComparableAssert)Assertions.assertThat((Comparable)barMember).hasSameHashCodeAs((Object)barAddress)).isEqualTo((Object)new JChannelGroupMember((Address)barAddress))).isNotEqualTo((Object)new JChannelGroupMember((Address)fooAddress))).isNotEqualTo((Object)new LocalEmbeddedCacheManagerGroupMember("bar"))).isNotEqualTo((Object)LocalGroupMember.of((String)"bar"));
    }
}

