/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan;

import java.io.IOException;
import java.util.UUID;
import org.infinispan.protostream.descriptors.WireType;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.NodeVersion;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public enum AddressMarshaller implements ProtoStreamMarshaller<Address>
{
    INSTANCE;

    private static final int UUID_INDEX = 1;
    private static final int VERSION_INDEX = 2;
    private static final int SITE_INDEX = 3;
    private static final int RACK_INDEX = 4;
    private static final int MACHINE_INDEX = 5;

    public Class<? extends Address> getJavaClass() {
        return Address.class;
    }

    public Address readFrom(ProtoStreamReader reader) throws IOException {
        UUID id = null;
        NodeVersion version = null;
        String site = null;
        String rack = null;
        String machine = null;
        block7: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    id = (UUID)reader.readObject(UUID.class);
                    continue block7;
                }
                case 2: {
                    version = (NodeVersion)reader.readObject(NodeVersion.class);
                    continue block7;
                }
                case 3: {
                    site = reader.readString();
                    continue block7;
                }
                case 4: {
                    rack = reader.readString();
                    continue block7;
                }
                case 5: {
                    machine = reader.readString();
                    continue block7;
                }
            }
            reader.skipField(tag);
        }
        return id != null ? Address.protoFactory((long)id.getMostSignificantBits(), (long)id.getLeastSignificantBits(), (NodeVersion)version, (String)site, (String)rack, (String)machine) : Address.LOCAL;
    }

    public void writeTo(ProtoStreamWriter writer, Address address) throws IOException {
        if (address != Address.LOCAL) {
            String machine;
            String rack;
            String site;
            writer.writeObject(1, (Object)address.getNodeUUID());
            NodeVersion version = address.getVersion();
            if (version != null) {
                writer.writeObject(2, (Object)version);
            }
            if ((site = address.getSiteId()) != null) {
                writer.writeString(3, site);
            }
            if ((rack = address.getRackId()) != null) {
                writer.writeString(4, rack);
            }
            if ((machine = address.getMachineId()) != null) {
                writer.writeString(5, machine);
            }
        }
    }
}

