/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.NodeVersion;
import org.jboss.marshalling.Externalizer;
import org.jgroups.util.UUID;
import org.wildfly.clustering.marshalling.Formatter;
import org.wildfly.clustering.marshalling.Serializer;
import org.wildfly.clustering.marshalling.jboss.ExternalizerProvider;
import org.wildfly.clustering.marshalling.jboss.SerializerExternalizer;

public enum AddressSerializer implements Serializer<Address>
{
    INSTANCE;


    public void write(DataOutput output, Address address) throws IOException {
        boolean local = address == Address.LOCAL;
        output.writeBoolean(local);
        if (!local) {
            output.writeLong(address.getMostSignificantBits());
            output.writeLong(address.getLeastSignificantBits());
            NodeVersion version = address.getVersion();
            if (version != null) {
                output.writeByte(version.getMajor());
                output.writeByte(version.getMinor());
                output.writeByte(version.getPatch());
            } else {
                output.writeByte(0);
            }
            AddressSerializer.writeString(output, address.getSiteId());
            AddressSerializer.writeString(output, address.getRackId());
            AddressSerializer.writeString(output, address.getMachineId());
        }
    }

    private static void writeString(DataOutput output, String value) throws IOException {
        output.writeUTF(value != null ? value : "");
    }

    public Address read(DataInput input) throws IOException {
        if (input.readBoolean()) {
            return Address.LOCAL;
        }
        long mostSignificant = input.readLong();
        long leastSignificant = input.readLong();
        byte major = input.readByte();
        NodeVersion version = major != 0 ? NodeVersion.from((byte)major, (byte)input.readByte(), (byte)input.readByte()) : null;
        String site = AddressSerializer.readString(input);
        String rack = AddressSerializer.readString(input);
        String machine = AddressSerializer.readString(input);
        return Address.protoFactory((long)mostSignificant, (long)leastSignificant, (NodeVersion)version, (String)site, (String)rack, (String)machine);
    }

    private static String readString(DataInput input) throws IOException {
        String value = input.readUTF();
        return value.isEmpty() ? null : value;
    }

    public static class JGroupsAddressFormatter
    implements Formatter<Address> {
        private static final String DELIMITER = "\t";

        public Class<? extends Address> getType() {
            return Address.class;
        }

        public Address parse(String value) {
            if (value.isEmpty()) {
                return Address.LOCAL;
            }
            String[] parts = value.split(Pattern.quote(DELIMITER));
            UUID uuid = UUID.fromString((String)parts[0]);
            NodeVersion version = parts.length > 1 ? NodeVersion.from((String)parts[1]) : null;
            String site = parts.length > 2 ? parts[2] : null;
            String rack = parts.length > 3 ? parts[3] : null;
            String machine = parts.length > 4 ? parts[4] : null;
            return Address.protoFactory((long)uuid.getMostSignificantBits(), (long)uuid.getLeastSignificantBits(), (NodeVersion)version, (String)site, (String)rack, (String)machine);
        }

        public String format(Address address) {
            ArrayList<String> parts = new ArrayList<String>(4);
            if (address != Address.LOCAL) {
                String machine;
                String rack;
                String site;
                parts.add(new UUID(address.getMostSignificantBits(), address.getLeastSignificantBits()).toStringLong());
                NodeVersion version = address.getVersion();
                if (version != null) {
                    parts.add(version.toString());
                }
                if ((site = address.getSiteId()) != null) {
                    parts.add(site);
                }
                if ((rack = address.getRackId()) != null) {
                    parts.add(rack);
                }
                if ((machine = address.getMachineId()) != null) {
                    parts.add(machine);
                }
            }
            return parts.stream().collect(Collectors.joining(DELIMITER));
        }
    }

    public static class JGroupsAddressExternalizerProvider
    implements ExternalizerProvider {
        private final Externalizer externalizer = new SerializerExternalizer((Serializer)INSTANCE);

        public Class<?> getType() {
            return Address.class;
        }

        public Externalizer getExternalizer() {
            return this.externalizer;
        }
    }
}

