/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan;

import java.io.IOException;
import org.infinispan.protostream.descriptors.WireType;
import org.infinispan.remoting.transport.NodeVersion;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public enum VersionMarshaller implements ProtoStreamMarshaller<NodeVersion>
{
    INSTANCE;

    private static final int MAJOR_INDEX = 1;
    private static final int MINOR_INDEX = 2;
    private static final int MICRO_INDEX = 3;
    private static final byte DEFAULT = 0;

    public Class<? extends NodeVersion> getJavaClass() {
        return NodeVersion.class;
    }

    public NodeVersion readFrom(ProtoStreamReader reader) throws IOException {
        byte major = 0;
        byte minor = 0;
        byte micro = 0;
        block5: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    major = (byte)reader.readUInt32();
                    continue block5;
                }
                case 2: {
                    minor = (byte)reader.readUInt32();
                    continue block5;
                }
                case 3: {
                    micro = (byte)reader.readUInt32();
                    continue block5;
                }
            }
            reader.skipField(tag);
        }
        return NodeVersion.from((byte)major, (byte)minor, (byte)micro);
    }

    public void writeTo(ProtoStreamWriter writer, NodeVersion version) throws IOException {
        byte micro;
        byte minor;
        byte major = version.getMajor();
        if (major != 0) {
            writer.writeUInt32(1, (int)major);
        }
        if ((minor = version.getMinor()) != 0) {
            writer.writeUInt32(2, (int)minor);
        }
        if ((micro = version.getPatch()) != 0) {
            writer.writeUInt32(3, (int)micro);
        }
    }
}

