/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.affinity;

import java.util.LinkedList;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.wildfly.clustering.cache.infinispan.CacheKey;
import org.wildfly.clustering.cache.infinispan.embedded.distribution.KeyDistribution;
import org.wildfly.clustering.function.Function;
import org.wildfly.clustering.function.Supplier;
import org.wildfly.clustering.server.infinispan.CacheContainerGroup;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMemberFactory;

public class NaryGroupMemberAffinity<I>
implements Function<I, List<CacheContainerGroupMember>> {
    private final Supplier<KeyDistribution> distribution;
    private final CacheContainerGroupMemberFactory factory;
    private final CacheContainerGroupMember localMember;

    public NaryGroupMemberAffinity(Cache<?, ?> cache, CacheContainerGroup group) {
        this((Supplier<KeyDistribution>)Supplier.of(cache).thenApply(KeyDistribution::forCache), group.getGroupMemberFactory(), (CacheContainerGroupMember)group.getLocalMember());
    }

    NaryGroupMemberAffinity(Supplier<KeyDistribution> distribution, CacheContainerGroupMemberFactory factory, CacheContainerGroupMember localMember) {
        this.distribution = distribution;
        this.factory = factory;
        this.localMember = localMember;
    }

    public List<CacheContainerGroupMember> apply(I id) {
        LinkedList<CacheContainerGroupMember> members = new LinkedList<CacheContainerGroupMember>();
        boolean locallyOwned = false;
        for (Address address : ((KeyDistribution)this.distribution.get()).getOwners((Object)new CacheKey(id))) {
            locallyOwned |= ((Address)this.localMember.getId()).equals((Object)address);
            members.add((CacheContainerGroupMember)this.factory.createGroupMember((Comparable)address));
        }
        if (!locallyOwned) {
            members.add(this.localMember);
        }
        return members;
    }
}

