/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.affinity;

import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.wildfly.clustering.cache.infinispan.CacheKey;
import org.wildfly.clustering.cache.infinispan.embedded.distribution.KeyDistribution;
import org.wildfly.clustering.function.Function;
import org.wildfly.clustering.function.Supplier;
import org.wildfly.clustering.server.infinispan.CacheContainerGroup;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMemberFactory;

public class UnaryGroupMemberAffinity<I>
implements Function<I, CacheContainerGroupMember> {
    private final Supplier<KeyDistribution> distribution;
    private final CacheContainerGroupMemberFactory factory;

    public UnaryGroupMemberAffinity(Cache<?, ?> cache, CacheContainerGroup group) {
        this((Supplier<KeyDistribution>)Supplier.of(cache).thenApply(KeyDistribution::forCache), group.getGroupMemberFactory());
    }

    UnaryGroupMemberAffinity(Supplier<KeyDistribution> distribution, CacheContainerGroupMemberFactory factory) {
        this.distribution = distribution;
        this.factory = factory;
    }

    public CacheContainerGroupMember apply(I id) {
        CacheContainerGroupMember member = null;
        while (member == null) {
            Address address = ((KeyDistribution)this.distribution.get()).getPrimaryOwner((Object)new CacheKey(id));
            if (address != null) {
                member = (CacheContainerGroupMember)this.factory.createGroupMember((Comparable)address);
                continue;
            }
            Thread.yield();
        }
        return member;
    }
}

