/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.expiration;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.server.infinispan.expiration.SimpleExpirationMetaData;

public enum SimpleExpirationMetaDataMarshaller implements ProtoStreamMarshaller<SimpleExpirationMetaData>
{
    INSTANCE;

    private static final int MAX_IDLE_INDEX = 1;
    private static final int LAST_ACCESS_TIME_INDEX = 2;

    public Class<? extends SimpleExpirationMetaData> getJavaClass() {
        return SimpleExpirationMetaData.class;
    }

    public SimpleExpirationMetaData readFrom(ProtoStreamReader reader) throws IOException {
        Optional<Duration> maxIdle = Optional.empty();
        Optional<Instant> lastAccessTime = Optional.empty();
        block4: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    maxIdle = Optional.of((Duration)reader.readObject(Duration.class));
                    continue block4;
                }
                case 2: {
                    lastAccessTime = Optional.of((Instant)reader.readObject(Instant.class));
                    continue block4;
                }
            }
            reader.skipField(tag);
        }
        return new SimpleExpirationMetaData(maxIdle, lastAccessTime);
    }

    public void writeTo(ProtoStreamWriter writer, SimpleExpirationMetaData metaData) throws IOException {
        writer.writeObject(1, metaData.getMaxIdle());
        writer.writeObject(2, metaData.getLastAccessTime());
    }
}

