/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.scheduler;

import io.github.resilience4j.core.functions.CheckedFunction;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionStage;
import org.wildfly.clustering.cache.infinispan.embedded.listener.ListenerRegistration;
import org.wildfly.clustering.function.Function;
import org.wildfly.clustering.server.GroupMember;
import org.wildfly.clustering.server.dispatcher.Command;
import org.wildfly.clustering.server.dispatcher.CommandDispatcher;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;
import org.wildfly.clustering.server.infinispan.affinity.UnaryGroupMemberAffinity;
import org.wildfly.clustering.server.infinispan.dispatcher.CacheContainerCommandDispatcherFactory;
import org.wildfly.clustering.server.infinispan.scheduler.CancelCommand;
import org.wildfly.clustering.server.infinispan.scheduler.ContainsCommand;
import org.wildfly.clustering.server.infinispan.scheduler.PrimaryOwnerCommand;
import org.wildfly.clustering.server.infinispan.scheduler.ScheduleCommand;
import org.wildfly.clustering.server.infinispan.scheduler.SchedulerTopologyChangeListenerRegistrar;
import org.wildfly.clustering.server.scheduler.DecoratedSchedulerService;
import org.wildfly.clustering.server.scheduler.Scheduler;
import org.wildfly.clustering.server.scheduler.SchedulerService;

public class PrimaryOwnerSchedulerService<K, V>
extends DecoratedSchedulerService<K, V> {
    private static final System.Logger LOGGER = System.getLogger(PrimaryOwnerSchedulerService.class.getName());
    private final String name;
    private final CommandDispatcher<CacheContainerGroupMember, Scheduler<K, V>> dispatcher;
    private final CheckedFunction<Map.Entry<K, V>, CompletionStage<Void>> primaryOwnerSchedule;
    private final CheckedFunction<K, CompletionStage<Void>> primaryOwnerCancel;
    private final CheckedFunction<K, CompletionStage<Boolean>> primaryOwnerContains;
    private final ListenerRegistration listenerRegistration;

    public <SE, CE> PrimaryOwnerSchedulerService(Configuration<K, V, SE, CE> configuration) {
        super(configuration.getScheduler());
        this.name = configuration.getName();
        this.dispatcher = configuration.getCommandDispatcherFactory().createCommandDispatcher(this.name, configuration.getScheduler(), configuration.getClassLoader());
        Function<K, CacheContainerGroupMember> affinity = configuration.getAffinity();
        Retry retry = Retry.of((String)this.name, (RetryConfig)configuration.getCacheConfiguration().getRetryConfig());
        this.primaryOwnerSchedule = Retry.decorateCheckedFunction((Retry)retry, new PrimaryOwnerCommandExecutionFunction<K, V, Map.Entry<K, V>, Void>(this.dispatcher, affinity, configuration.getScheduleCommandFactory()));
        this.primaryOwnerCancel = Retry.decorateCheckedFunction((Retry)retry, new PrimaryOwnerCommandExecutionFunction(this.dispatcher, affinity, CancelCommand::new));
        this.primaryOwnerContains = Retry.decorateCheckedFunction((Retry)retry, new PrimaryOwnerCommandExecutionFunction(this.dispatcher, affinity, ContainsCommand::new));
        this.listenerRegistration = new SchedulerTopologyChangeListenerRegistrar<K, V, SE, CE>(configuration).register();
    }

    public void close() {
        this.listenerRegistration.close();
        this.dispatcher.close();
        super.close();
    }

    public void schedule(K id, V metaData) {
        try {
            ((CompletionStage)this.primaryOwnerSchedule.apply(Map.entry(id, metaData))).toCompletableFuture().join();
        }
        catch (CancellationException cancellationException) {
        }
        catch (Throwable e) {
            LOGGER.log(System.Logger.Level.WARNING, e.getLocalizedMessage(), e);
        }
    }

    public void cancel(K id) {
        try {
            ((CompletionStage)this.primaryOwnerCancel.apply(id)).toCompletableFuture().join();
        }
        catch (CancellationException cancellationException) {
        }
        catch (Throwable e) {
            LOGGER.log(System.Logger.Level.WARNING, e.getLocalizedMessage(), e);
        }
    }

    public boolean contains(K id) {
        try {
            return (Boolean)((CompletionStage)this.primaryOwnerContains.apply(id)).toCompletableFuture().join();
        }
        catch (CancellationException e) {
            return false;
        }
        catch (Throwable e) {
            LOGGER.log(System.Logger.Level.WARNING, e.getLocalizedMessage(), e);
            return false;
        }
    }

    public static interface Configuration<K, V, SE, CE>
    extends SchedulerTopologyChangeListenerRegistrar.Configuration<K, V, SE, CE> {
        default public String getName() {
            return this.getCacheConfiguration().getName();
        }

        public SchedulerService<K, V> getScheduler();

        public CacheContainerCommandDispatcherFactory getCommandDispatcherFactory();

        default public Function<Map.Entry<K, V>, PrimaryOwnerCommand<K, V, Void>> getScheduleCommandFactory() {
            return ScheduleCommand::new;
        }

        default public Function<K, CacheContainerGroupMember> getAffinity() {
            return new UnaryGroupMemberAffinity(this.getCacheConfiguration().getCache(), this.getCommandDispatcherFactory().getGroup());
        }

        default public ClassLoader getClassLoader() {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return this.getScheduler().getClass().getClassLoader();
                }
            });
        }
    }

    private static class PrimaryOwnerCommandExecutionFunction<K, V, T, R>
    implements CheckedFunction<T, CompletionStage<R>> {
        private final CommandDispatcher<CacheContainerGroupMember, Scheduler<K, V>> dispatcher;
        private final Function<K, CacheContainerGroupMember> affinity;
        private final Function<T, PrimaryOwnerCommand<K, V, R>> commandFactory;

        PrimaryOwnerCommandExecutionFunction(CommandDispatcher<CacheContainerGroupMember, Scheduler<K, V>> dispatcher, Function<K, CacheContainerGroupMember> affinity, Function<T, PrimaryOwnerCommand<K, V, R>> commandFactory) {
            this.dispatcher = dispatcher;
            this.affinity = affinity;
            this.commandFactory = commandFactory;
        }

        public CompletionStage<R> apply(T value) throws IOException {
            PrimaryOwnerCommand command = (PrimaryOwnerCommand)this.commandFactory.apply(value);
            CacheContainerGroupMember primaryOwner = (CacheContainerGroupMember)this.affinity.apply(command.getKey());
            return this.dispatcher.dispatchToMember((Command)command, (GroupMember)primaryOwner);
        }
    }
}

