/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.jgroups.dispatcher;

import java.util.function.Function;
import java.util.function.Predicate;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamTesterFactory;
import org.wildfly.clustering.server.jgroups.ChannelGroupMember;
import org.wildfly.clustering.server.jgroups.JChannelFactory;
import org.wildfly.clustering.server.jgroups.dispatcher.ChannelCommandDispatcherFactory;
import org.wildfly.clustering.server.jgroups.dispatcher.CommandDispatcherITCaseConfiguration;
import org.wildfly.clustering.server.jgroups.dispatcher.JChannelCommandDispatcherFactory;
import org.wildfly.clustering.server.jgroups.dispatcher.JChannelCommandDispatcherFactoryConfiguration;

public class ChannelCommandDispatcherITCaseConfiguration
implements CommandDispatcherITCaseConfiguration<ChannelGroupMember>,
JChannelCommandDispatcherFactoryConfiguration {
    private final JChannel channel;
    private final ChannelCommandDispatcherFactory factory;

    public ChannelCommandDispatcherITCaseConfiguration(String clusterName, String memberName) throws Exception {
        this.channel = JChannelFactory.INSTANCE.apply(memberName);
        this.channel.connect(clusterName);
        this.factory = new JChannelCommandDispatcherFactory((JChannelCommandDispatcherFactoryConfiguration)this);
    }

    public ChannelCommandDispatcherFactory getCommandDispatcherFactory() {
        return this.factory;
    }

    public Predicate<Message> getUnknownForkPredicate() {
        return Predicate.not(Message::hasPayload);
    }

    public JChannel getChannel() {
        return this.channel;
    }

    public ByteBufferMarshaller getMarshaller() {
        return ProtoStreamTesterFactory.INSTANCE.getMarshaller();
    }

    public Function<ClassLoader, ByteBufferMarshaller> getMarshallerFactory() {
        return loader -> ProtoStreamTesterFactory.INSTANCE.getMarshaller();
    }

    @Override
    public void close() throws Exception {
        this.factory.close();
        this.channel.close();
    }
}

