/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.jgroups;

import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.jgroups.Address;
import org.jgroups.util.NameCache;
import org.wildfly.clustering.server.group.GroupMember;
import org.wildfly.clustering.server.jgroups.AddressSerializer;
import org.wildfly.clustering.server.jgroups.ChannelGroupMember;

public class JChannelGroupMember
implements ChannelGroupMember,
Serializable {
    private static final long serialVersionUID = 3818614808896402906L;
    private final Address address;

    public JChannelGroupMember(Address address) {
        this.address = address;
    }

    public String getName() {
        return NameCache.get((Address)this.address);
    }

    public Address getAddress() {
        return this.address;
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ChannelGroupMember)) {
            return false;
        }
        ChannelGroupMember member = (ChannelGroupMember)object;
        return this.address.equals((Object)member.getAddress());
    }

    public String toString() {
        return this.getName();
    }

    public int compareTo(GroupMember<Address> member) {
        return this.address.compareTo((Object)((Address)member.getAddress()));
    }

    Object writeReplace() throws ObjectStreamException {
        return new JChannelGroupMemberProxy(this.address);
    }

    static class JChannelGroupMemberProxy
    implements Serializable {
        private static final long serialVersionUID = 1154615703830003932L;
        private transient Address address;

        JChannelGroupMemberProxy(Address address) {
            this.address = address;
        }

        private void writeObject(ObjectOutputStream output) throws IOException {
            output.defaultWriteObject();
            AddressSerializer.INSTANCE.write((DataOutput)output, this.address);
        }

        private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
            input.defaultReadObject();
            this.address = AddressSerializer.INSTANCE.read(input);
        }

        Object readResolve() throws ObjectStreamException {
            return new JChannelGroupMember(this.address);
        }
    }
}

