/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.jgroups.dispatcher;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.jgroups.Address;
import org.jgroups.BytesMessage;
import org.jgroups.Message;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RspFilter;
import org.wildfly.clustering.server.dispatcher.Command;
import org.wildfly.clustering.server.dispatcher.CommandDispatcher;
import org.wildfly.clustering.server.jgroups.ChannelGroup;
import org.wildfly.clustering.server.jgroups.ChannelGroupMember;
import org.wildfly.clustering.server.jgroups.dispatcher.CommandMarshaller;
import org.wildfly.clustering.server.jgroups.dispatcher.ServiceRequest;
import org.wildfly.clustering.server.jgroups.dispatcher.ServiceResponse;

public class JChannelCommandDispatcher<CC, MC>
implements CommandDispatcher<ChannelGroupMember, CC> {
    private static final RspFilter FILTER = new RspFilter(){

        public boolean isAcceptable(Object response, Address sender) {
            return !(response instanceof ServiceResponse);
        }

        public boolean needMoreResponses() {
            return true;
        }
    };
    private final CC commandContext;
    private final MessageDispatcher dispatcher;
    private final CommandMarshaller<CC> marshaller;
    private final MC marshallingContext;
    private final ChannelGroup group;
    private final Duration timeout;
    private final Runnable closeTask;
    private final RequestOptions options;

    public JChannelCommandDispatcher(CC commandContext, MessageDispatcher dispatcher, CommandMarshaller<CC> marshaller, MC marshallingContext, ChannelGroup group, Duration timeout, Runnable closeTask) {
        this.commandContext = commandContext;
        this.dispatcher = dispatcher;
        this.marshaller = marshaller;
        this.marshallingContext = marshallingContext;
        this.group = group;
        this.timeout = timeout;
        this.closeTask = closeTask;
        this.options = new RequestOptions(ResponseMode.GET_ALL, this.timeout.toMillis(), false, FILTER, new Message.Flag[]{Message.Flag.DONT_BUNDLE, Message.Flag.OOB});
    }

    public CC getContext() {
        return this.commandContext;
    }

    public void close() {
        this.closeTask.run();
    }

    public <R, E extends Exception> CompletionStage<R> dispatchToMember(Command<R, ? super CC, E> command, ChannelGroupMember member) throws IOException {
        if (((ChannelGroupMember)this.group.getLocalMember()).equals(member)) {
            return this.execute(command);
        }
        ByteBuffer buffer = this.createBuffer(command);
        Address address = (Address)member.getAddress();
        Message message = this.createMessage(buffer, address);
        ServiceRequest request = new ServiceRequest(this.dispatcher.getCorrelator(), address, this.options, this.marshallingContext);
        return request.send(message);
    }

    public <R, E extends Exception> Map<ChannelGroupMember, CompletionStage<R>> dispatchToGroup(Command<R, ? super CC, E> command, Set<ChannelGroupMember> excluding) throws IOException {
        ConcurrentHashMap<ChannelGroupMember, CompletionStage<R>> results = new ConcurrentHashMap<ChannelGroupMember, CompletionStage<R>>();
        ByteBuffer buffer = this.createBuffer(command);
        for (ChannelGroupMember member : this.group.getMembership().getMembers()) {
            if (excluding.contains(member)) continue;
            if (((ChannelGroupMember)this.group.getLocalMember()).equals(member)) {
                results.put(member, this.execute(command));
                continue;
            }
            Address address = (Address)member.getAddress();
            try {
                ServiceRequest request = new ServiceRequest(this.dispatcher.getCorrelator(), address, this.options, this.marshallingContext);
                Message message = this.createMessage(buffer, address);
                CompletionStage future = request.send(message);
                future.whenComplete(new PruneCancellationTask<R>(results, member));
                results.put(member, future);
            }
            catch (IOException e) {
                for (CompletionStage result : results.values()) {
                    result.toCompletableFuture().cancel(true);
                }
                throw e;
            }
        }
        return results;
    }

    private <R, E extends Exception> CompletionStage<R> execute(Command<R, ? super CC, E> command) {
        try {
            return CompletableFuture.completedStage(command.execute(this.commandContext));
        }
        catch (Exception e) {
            return CompletableFuture.failedStage(e);
        }
    }

    private <R, E extends Exception> ByteBuffer createBuffer(Command<R, ? super CC, E> command) {
        try {
            return this.marshaller.marshal(command);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Message createMessage(ByteBuffer buffer, Address destination) {
        return new BytesMessage().setArray(buffer.array(), buffer.arrayOffset(), buffer.limit() - buffer.arrayOffset()).src((Address)((ChannelGroupMember)this.group.getLocalMember()).getAddress()).dest(destination);
    }

    private static class PruneCancellationTask<R>
    implements BiConsumer<R, Throwable> {
        private final Map<ChannelGroupMember, CompletionStage<R>> results;
        private final ChannelGroupMember member;

        PruneCancellationTask(Map<ChannelGroupMember, CompletionStage<R>> results, ChannelGroupMember member) {
            this.results = results;
            this.member = member;
        }

        @Override
        public void accept(R result, Throwable exception) {
            if (exception instanceof CancellationException) {
                this.results.remove(this.member);
            }
        }
    }
}

