/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.jgroups.dispatcher;

import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.SuspectedException;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.UnicastRequest;
import org.wildfly.clustering.marshalling.MarshalledValue;
import org.wildfly.clustering.server.jgroups.dispatcher.ServiceResponse;

public class ServiceRequest<T, C>
extends UnicastRequest<T> {
    private final C context;

    public ServiceRequest(RequestCorrelator correlator, Address target, RequestOptions options, C context) {
        super(correlator, target, options);
        this.context = context;
    }

    public CompletionStage<T> send(Message message) throws IOException {
        try {
            this.sendRequest(message);
            return this;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void receiveResponse(Object value, Address sender, boolean exceptional) {
        if (this.isDone()) {
            return;
        }
        if (exceptional) {
            this.completeExceptionally((Throwable)value);
        } else if (value instanceof ServiceResponse) {
            this.completeExceptionally(new CancellationException());
        } else {
            MarshalledValue marshalledValue = (MarshalledValue)value;
            try {
                this.complete(marshalledValue.get(this.context));
            }
            catch (IOException e) {
                this.completeExceptionally(e);
            }
        }
        this.corrDone();
    }

    public boolean completeExceptionally(Throwable exception) {
        return super.completeExceptionally(exception instanceof SuspectedException ? new CancellationException() : exception);
    }

    public T get() throws InterruptedException, ExecutionException {
        try {
            return (T)super.get(this.options.timeout(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            this.cancel(true);
            throw new CancellationException(e.getLocalizedMessage());
        }
    }

    public T join() {
        try {
            return this.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CompletionException(e);
        }
        catch (ExecutionException e) {
            throw new CompletionException(e.getCause());
        }
    }
}

