/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.jgroups;

import java.util.List;
import java.util.stream.Collectors;
import org.jgroups.View;
import org.wildfly.clustering.server.group.GroupMembership;
import org.wildfly.clustering.server.jgroups.ChannelGroupMember;
import org.wildfly.clustering.server.jgroups.ChannelGroupMemberFactory;

public class ViewMembership
implements GroupMembership<ChannelGroupMember> {
    private final long id;
    private final List<ChannelGroupMember> members;
    private final int coordinatorIndex;

    public ViewMembership(View view, ChannelGroupMemberFactory factory) {
        this.id = view.getViewId().getId();
        List addresses = view.getMembers();
        this.members = addresses.stream().map(arg_0 -> ((ChannelGroupMemberFactory)factory).createGroupMember(arg_0)).collect(Collectors.toUnmodifiableList());
        this.coordinatorIndex = addresses.indexOf(view.getCoord());
    }

    public int getCoordinatorIndex() {
        return this.coordinatorIndex;
    }

    public List<ChannelGroupMember> getMembers() {
        return this.members;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ViewMembership)) {
            return false;
        }
        ViewMembership membership = (ViewMembership)object;
        return this.id == membership.id;
    }

    public String toString() {
        return this.members.toString();
    }
}

