/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.jgroups;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.View;
import org.jgroups.protocols.DISCARD;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.server.GroupMembership;
import org.wildfly.clustering.server.GroupMembershipEvent;
import org.wildfly.clustering.server.GroupMembershipListener;
import org.wildfly.clustering.server.GroupMembershipMergeEvent;
import org.wildfly.clustering.server.Registration;
import org.wildfly.clustering.server.group.Group;
import org.wildfly.clustering.server.group.GroupMember;
import org.wildfly.clustering.server.jgroups.GroupProvider;
import org.wildfly.common.function.ExceptionBiFunction;

public abstract class GroupITCase<A extends Comparable<A>, M extends GroupMember<A>> {
    private static final String CLUSTER_NAME = "cluster";
    private static final String[] MEMBER_NAMES = new String[]{"member0", "member1", "member2"};
    private static final Duration VIEW_CHANGE_DURATION = Duration.ofSeconds(20L);
    private static final Duration SPLIT_MERGE_DURATION = Duration.ofSeconds(120L);
    private final ExceptionBiFunction<String, String, GroupProvider<A, M>, Exception> factory;
    private final Function<A, Address> mapper;

    protected GroupITCase(ExceptionBiFunction<String, String, GroupProvider<A, M>, Exception> factory, Function<A, Address> mapper) {
        this.factory = factory;
        this.mapper = mapper;
    }

    @Test
    public void test() throws Exception {
        try (GroupProvider provider1 = (GroupProvider)this.factory.apply((Object)CLUSTER_NAME, (Object)MEMBER_NAMES[0]);){
            Group group1 = provider1.getGroup();
            JChannel channel1 = provider1.getChannel();
            Assertions.assertSame((Object)provider1.getName(), (Object)group1.getName());
            Assertions.assertEquals((Object)MEMBER_NAMES[0], (Object)((GroupMember)group1.getLocalMember()).getName());
            Assertions.assertFalse((boolean)group1.isSingleton());
            this.validate(channel1, group1);
            GroupMembership previousMembership = null;
            GroupMembership currentMembership = group1.getMembership();
            Assertions.assertEquals((Object)group1.getLocalMember(), (Object)currentMembership.getCoordinator());
            Assertions.assertEquals(List.of((GroupMember)group1.getLocalMember()), (Object)currentMembership.getMembers());
            final LinkedBlockingQueue updateEvents = new LinkedBlockingQueue();
            final LinkedBlockingQueue splitEvents = new LinkedBlockingQueue();
            final LinkedBlockingQueue mergeEvents = new LinkedBlockingQueue();
            GroupMembershipListener listener = new GroupMembershipListener<M>(this){
                final /* synthetic */ GroupITCase this$0;
                {
                    this.this$0 = this$0;
                }

                public void updated(GroupMembershipEvent<M> event) {
                    updateEvents.add(event);
                }

                public void split(GroupMembershipEvent<M> event) {
                    splitEvents.add(event);
                }

                public void merged(GroupMembershipMergeEvent<M> event) {
                    mergeEvents.add(event);
                }
            };
            try (Registration registration = group1.register((Object)listener);){
                GroupMembershipEvent updateEvent = (GroupMembershipEvent)updateEvents.poll();
                GroupMembershipEvent splitEvent = (GroupMembershipEvent)splitEvents.poll();
                GroupMembershipMergeEvent mergeEvent = (GroupMembershipMergeEvent)mergeEvents.poll();
                Assertions.assertNull((Object)updateEvent);
                Assertions.assertNull((Object)splitEvent);
                Assertions.assertNull((Object)mergeEvent);
                try (GroupProvider provider2 = (GroupProvider)this.factory.apply((Object)CLUSTER_NAME, (Object)MEMBER_NAMES[1]);){
                    JChannel channel2 = provider2.getChannel();
                    Assertions.assertEquals((Object)channel1.getView(), (Object)channel2.getView());
                    Assertions.assertEquals((int)2, (int)channel1.getView().size());
                    Instant start = Instant.now();
                    updateEvent = (GroupMembershipEvent)updateEvents.poll(VIEW_CHANGE_DURATION.toSeconds(), TimeUnit.SECONDS);
                    System.out.println("View change detected after " + String.valueOf(Duration.between(start, Instant.now())));
                    splitEvent = (GroupMembershipEvent)splitEvents.poll();
                    mergeEvent = (GroupMembershipMergeEvent)mergeEvents.poll();
                    Assertions.assertNull((Object)splitEvent);
                    Assertions.assertNull((Object)mergeEvent);
                    Assertions.assertNotNull((Object)updateEvent);
                    previousMembership = currentMembership;
                    currentMembership = group1.getMembership();
                    Assertions.assertEquals((Object)previousMembership, (Object)updateEvent.getPreviousMembership());
                    Assertions.assertEquals((Object)currentMembership, (Object)updateEvent.getCurrentMembership());
                    Group group2 = provider2.getGroup();
                    Assertions.assertSame((Object)provider2.getName(), (Object)group2.getName());
                    Assertions.assertEquals((Object)MEMBER_NAMES[1], (Object)((GroupMember)group2.getLocalMember()).getName());
                    Assertions.assertFalse((boolean)group2.isSingleton());
                    this.validate(channel1, group1);
                    this.validate(channel2, group2);
                    GroupMembership membership2 = group2.getMembership();
                    Assertions.assertEquals((Object)currentMembership, (Object)membership2);
                    Assertions.assertEquals((Object)currentMembership.getCoordinator(), (Object)membership2.getCoordinator());
                    Assertions.assertEquals((Object)currentMembership.getMembers(), (Object)membership2.getMembers());
                    try (GroupProvider provider3 = (GroupProvider)this.factory.apply((Object)CLUSTER_NAME, (Object)MEMBER_NAMES[2]);){
                        JChannel channel3 = provider3.getChannel();
                        Assertions.assertEquals((Object)channel1.getView(), (Object)channel3.getView());
                        Assertions.assertEquals((int)3, (int)channel1.getView().size());
                        start = Instant.now();
                        updateEvent = (GroupMembershipEvent)updateEvents.poll(VIEW_CHANGE_DURATION.toSeconds(), TimeUnit.SECONDS);
                        System.out.println("View change detected after " + String.valueOf(Duration.between(start, Instant.now())));
                        splitEvent = (GroupMembershipEvent)splitEvents.poll();
                        mergeEvent = (GroupMembershipMergeEvent)mergeEvents.poll();
                        Assertions.assertNull((Object)mergeEvent);
                        Assertions.assertNull((Object)splitEvent);
                        Assertions.assertNotNull((Object)updateEvent);
                        previousMembership = currentMembership;
                        currentMembership = group1.getMembership();
                        Assertions.assertEquals((Object)previousMembership, (Object)updateEvent.getPreviousMembership());
                        Assertions.assertEquals((Object)currentMembership, (Object)updateEvent.getCurrentMembership());
                        Group group3 = provider3.getGroup();
                        Assertions.assertSame((Object)provider3.getName(), (Object)group3.getName());
                        Assertions.assertEquals((Object)MEMBER_NAMES[2], (Object)((GroupMember)group3.getLocalMember()).getName());
                        Assertions.assertFalse((boolean)group3.isSingleton());
                        this.validate(channel1, group1);
                        this.validate(channel2, group2);
                        this.validate(channel3, group3);
                        GroupMembership membership3 = group3.getMembership();
                        Assertions.assertEquals((Object)currentMembership, (Object)membership3);
                        Assertions.assertEquals((Object)currentMembership.getCoordinator(), (Object)membership3.getCoordinator());
                        Assertions.assertEquals((Object)currentMembership.getMembers(), (Object)membership3.getMembers());
                        System.out.println("Simulating network partition");
                        DISCARD discard1 = new DISCARD().discardAll(true);
                        channel1.getProtocolStack().insertProtocol((Protocol)discard1, ProtocolStack.Position.ABOVE, TP.class);
                        start = Instant.now();
                        splitEvent = (GroupMembershipEvent)splitEvents.poll(SPLIT_MERGE_DURATION.toSeconds(), TimeUnit.SECONDS);
                        System.out.println("Network partition created after " + String.valueOf(Duration.between(start, Instant.now())));
                        updateEvent = (GroupMembershipEvent)updateEvents.poll();
                        mergeEvent = (GroupMembershipMergeEvent)mergeEvents.poll();
                        Assertions.assertNull((Object)mergeEvent);
                        Assertions.assertNull((Object)updateEvent);
                        Assertions.assertNotNull((Object)splitEvent);
                        this.validate(channel1, group1);
                        this.validate(channel2, group2);
                        this.validate(channel3, group3);
                        previousMembership = currentMembership;
                        currentMembership = group1.getMembership();
                        Assertions.assertEquals((Object)previousMembership, (Object)splitEvent.getPreviousMembership());
                        Assertions.assertEquals((Object)currentMembership, (Object)splitEvent.getCurrentMembership());
                        Assertions.assertEquals((int)1, (int)currentMembership.getMembers().size());
                        Assertions.assertEquals((Object)group1.getLocalMember(), (Object)currentMembership.getCoordinator());
                        Assertions.assertEquals(List.of((GroupMember)group1.getLocalMember()), (Object)currentMembership.getMembers());
                        System.out.println("Resolving network partition");
                        channel1.getProtocolStack().removeProtocol(DISCARD.class);
                        start = Instant.now();
                        mergeEvent = (GroupMembershipMergeEvent)mergeEvents.poll(SPLIT_MERGE_DURATION.toSeconds(), TimeUnit.SECONDS);
                        System.out.println("Network partition resolved after " + String.valueOf(Duration.between(start, Instant.now())));
                        splitEvent = (GroupMembershipEvent)splitEvents.poll();
                        updateEvent = (GroupMembershipEvent)updateEvents.poll();
                        Assertions.assertNull((Object)updateEvent);
                        Assertions.assertNull((Object)splitEvent);
                        Assertions.assertNotNull((Object)mergeEvent);
                        this.validate(channel1, group1);
                        this.validate(channel2, group2);
                        this.validate(channel3, group3);
                        previousMembership = currentMembership;
                        currentMembership = group1.getMembership();
                        Assertions.assertEquals((Object)previousMembership, (Object)mergeEvent.getPreviousMembership());
                        Assertions.assertEquals((Object)currentMembership, (Object)mergeEvent.getCurrentMembership());
                        Assertions.assertEquals((int)3, (int)currentMembership.getMembers().size());
                        Assertions.assertEquals((int)2, (int)mergeEvent.getPartitions().size());
                        Assertions.assertTrue((boolean)mergeEvent.getPartitions().contains(previousMembership));
                    }
                    start = Instant.now();
                    updateEvent = (GroupMembershipEvent)updateEvents.poll(VIEW_CHANGE_DURATION.toSeconds(), TimeUnit.SECONDS);
                    System.out.println("View change detected after " + String.valueOf(Duration.between(start, Instant.now())));
                    splitEvent = (GroupMembershipEvent)splitEvents.poll();
                    mergeEvent = (GroupMembershipMergeEvent)mergeEvents.poll();
                    Assertions.assertNull((Object)mergeEvent);
                    Assertions.assertNull((Object)splitEvent);
                    Assertions.assertNotNull((Object)updateEvent);
                    this.validate(channel1, group1);
                    this.validate(channel2, group2);
                    previousMembership = currentMembership;
                    currentMembership = group1.getMembership();
                    Assertions.assertEquals((Object)previousMembership, (Object)updateEvent.getPreviousMembership());
                    Assertions.assertEquals((Object)currentMembership, (Object)updateEvent.getCurrentMembership());
                    Assertions.assertEquals((int)2, (int)currentMembership.getMembers().size());
                }
                Instant start = Instant.now();
                updateEvent = (GroupMembershipEvent)updateEvents.poll(VIEW_CHANGE_DURATION.toSeconds(), TimeUnit.SECONDS);
                System.out.println("View change detected after " + String.valueOf(Duration.between(start, Instant.now())));
                splitEvent = (GroupMembershipEvent)splitEvents.poll();
                mergeEvent = (GroupMembershipMergeEvent)mergeEvents.poll();
                Assertions.assertNull((Object)splitEvent);
                Assertions.assertNull((Object)mergeEvent);
                Assertions.assertNotNull((Object)updateEvent);
                this.validate(channel1, group1);
                previousMembership = currentMembership;
                currentMembership = group1.getMembership();
                Assertions.assertEquals((Object)previousMembership, (Object)updateEvent.getPreviousMembership());
                Assertions.assertEquals((Object)currentMembership, (Object)updateEvent.getCurrentMembership());
                Assertions.assertEquals((Object)group1.getLocalMember(), (Object)currentMembership.getCoordinator());
                Assertions.assertEquals((int)1, (int)currentMembership.getMembers().size());
                Assertions.assertEquals(List.of((GroupMember)group1.getLocalMember()), (Object)currentMembership.getMembers());
            }
        }
    }

    private void validate(JChannel channel, Group<A, M> group) {
        Assertions.assertEquals((Object)channel.getName(), (Object)((GroupMember)group.getLocalMember()).getName());
        Assertions.assertEquals((Object)channel.getAddress(), (Object)this.mapper.apply(((GroupMember)group.getLocalMember()).getAddress()));
        View view = channel.getView();
        GroupMembership membership = group.getMembership();
        Assertions.assertEquals((Object)view.getCoord(), (Object)this.mapper.apply(((GroupMember)membership.getCoordinator()).getAddress()));
        Assertions.assertEquals((Object)view.getMembers(), membership.getMembers().stream().map(GroupMember::getAddress).map(this.mapper).collect(Collectors.toUnmodifiableList()));
    }
}

