/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.jgroups.dispatcher;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionStage;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.server.Group;
import org.wildfly.clustering.server.GroupMember;
import org.wildfly.clustering.server.dispatcher.CommandDispatcher;
import org.wildfly.clustering.server.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.server.jgroups.dispatcher.CommandDispatcherFactoryProvider;
import org.wildfly.clustering.server.jgroups.dispatcher.test.IdentityCommand;
import org.wildfly.common.function.ExceptionBiFunction;

public abstract class CommandDispatcherITCase<M extends GroupMember> {
    private static final String CLUSTER_NAME = "cluster";
    private final ExceptionBiFunction<String, String, CommandDispatcherFactoryProvider<M>, Exception> factory;

    protected CommandDispatcherITCase(ExceptionBiFunction<String, String, CommandDispatcherFactoryProvider<M>, Exception> factory) {
        this.factory = factory;
    }

    @Test
    public void test() throws Exception {
        try (CommandDispatcherFactoryProvider provider1 = (CommandDispatcherFactoryProvider)this.factory.apply((Object)CLUSTER_NAME, (Object)"member1");){
            CommandDispatcherFactory factory1 = provider1.getCommandDispatcherFactory();
            Group group1 = factory1.getGroup();
            UUID fooContext1 = UUID.randomUUID();
            try (CommandDispatcher dispatcher1 = factory1.createCommandDispatcher((Object)"foo", (Object)fooContext1);){
                Assertions.assertThat((Comparable)((UUID)dispatcher1.getContext())).isSameAs((Object)fooContext1);
                Assertions.assertThat((Comparable)((UUID)dispatcher1.dispatchToMember(new IdentityCommand(), group1.getLocalMember()).toCompletableFuture().join())).isSameAs((Object)fooContext1);
                Map results = dispatcher1.dispatchToGroup(new IdentityCommand());
                Assertions.assertThat((Map)results).containsOnlyKeys((Object[])new GroupMember[]{group1.getLocalMember()});
                Assertions.assertThat((Comparable)((UUID)((CompletionStage)results.get(group1.getLocalMember())).toCompletableFuture().join())).isSameAs((Object)fooContext1);
                Assertions.assertThat((Map)dispatcher1.dispatchToGroup(new IdentityCommand(), Set.of(group1.getLocalMember()))).isEmpty();
                try (CommandDispatcherFactoryProvider provider2 = (CommandDispatcherFactoryProvider)this.factory.apply((Object)CLUSTER_NAME, (Object)"member2");){
                    CommandDispatcherFactory factory2 = provider2.getCommandDispatcherFactory();
                    Group group2 = factory2.getGroup();
                    UUID fooContext2 = UUID.randomUUID();
                    try (CommandDispatcher dispatcher2 = factory2.createCommandDispatcher((Object)"foo", (Object)fooContext2);){
                        Assertions.assertThat((Comparable)((UUID)dispatcher2.getContext())).isSameAs((Object)fooContext2);
                        Assertions.assertThat((Comparable)((UUID)dispatcher2.dispatchToMember(new IdentityCommand(), group2.getLocalMember()).toCompletableFuture().join())).isSameAs((Object)fooContext2);
                        Assertions.assertThat((Comparable)((UUID)dispatcher2.dispatchToMember(new IdentityCommand(), group1.getLocalMember()).toCompletableFuture().join())).isEqualTo((Object)fooContext1);
                        results = dispatcher2.dispatchToGroup(new IdentityCommand());
                        Assertions.assertThat((Map)results).containsOnlyKeys((Object[])new GroupMember[]{group1.getLocalMember(), group2.getLocalMember()});
                        Assertions.assertThat((Comparable)((UUID)((CompletionStage)results.get(group1.getLocalMember())).toCompletableFuture().join())).isEqualTo((Object)fooContext1);
                        Assertions.assertThat((Comparable)((UUID)((CompletionStage)results.get(group2.getLocalMember())).toCompletableFuture().join())).isSameAs((Object)fooContext2);
                        results = dispatcher2.dispatchToGroup(new IdentityCommand(), Set.of(group1.getLocalMember()));
                        Assertions.assertThat((Map)results).containsOnlyKeys((Object[])new GroupMember[]{group2.getLocalMember()});
                        Assertions.assertThat((Comparable)((UUID)((CompletionStage)results.get(group2.getLocalMember())).toCompletableFuture().join())).isSameAs((Object)fooContext2);
                        results = dispatcher2.dispatchToGroup(new IdentityCommand(), Set.of(group2.getLocalMember()));
                        Assertions.assertThat((Map)results).containsOnlyKeys((Object[])new GroupMember[]{group1.getLocalMember()});
                        Assertions.assertThat((Comparable)((UUID)((CompletionStage)results.get(group1.getLocalMember())).toCompletableFuture().join())).isEqualTo((Object)fooContext1);
                        Assertions.assertThat((Map)dispatcher2.dispatchToGroup(new IdentityCommand(), Set.of(group1.getLocalMember(), group2.getLocalMember()))).isEmpty();
                    }
                    results = dispatcher1.dispatchToGroup(new IdentityCommand());
                    Assertions.assertThat((Map)results).containsKey((Object)group1.getLocalMember());
                    Assertions.assertThat((Comparable)((UUID)((CompletionStage)results.get(group1.getLocalMember())).toCompletableFuture().join())).isSameAs((Object)fooContext1);
                    CompletionStage result = (CompletionStage)results.get(group2.getLocalMember());
                    if (result != null) {
                        Assertions.assertThatExceptionOfType(CancellationException.class).isThrownBy(result.toCompletableFuture()::join);
                    }
                    results = dispatcher1.dispatchToGroup(new IdentityCommand(), Set.of(group1.getLocalMember()));
                    Assertions.assertThat((Map)results).doesNotContainKey((Object)group1.getLocalMember());
                    result = (CompletionStage)results.get(group2.getLocalMember());
                    if (result != null) {
                        Assertions.assertThatExceptionOfType(CancellationException.class).isThrownBy(result.toCompletableFuture()::join);
                    }
                    Assertions.assertThatExceptionOfType(CancellationException.class).isThrownBy(dispatcher1.dispatchToMember(new IdentityCommand(), group2.getLocalMember()).toCompletableFuture()::join);
                    UUID barContext2 = UUID.randomUUID();
                    try (CommandDispatcher dispatcher2 = factory2.createCommandDispatcher((Object)"bar", (Object)barContext2);){
                        Assertions.assertThat((Comparable)((UUID)dispatcher2.getContext())).isSameAs((Object)barContext2);
                        Assertions.assertThat((Comparable)((UUID)dispatcher2.dispatchToMember(new IdentityCommand(), group2.getLocalMember()).toCompletableFuture().join())).isSameAs((Object)barContext2);
                        Assertions.assertThatExceptionOfType(CancellationException.class).isThrownBy(dispatcher2.dispatchToMember(new IdentityCommand(), group1.getLocalMember()).toCompletableFuture()::join);
                        results = dispatcher2.dispatchToGroup(new IdentityCommand());
                        result = (CompletionStage)results.get(group1.getLocalMember());
                        if (result != null) {
                            Assertions.assertThatExceptionOfType(CancellationException.class).isThrownBy(result.toCompletableFuture()::join);
                        }
                        Assertions.assertThat((Comparable)((UUID)((CompletionStage)results.get(group2.getLocalMember())).toCompletableFuture().join())).isSameAs((Object)barContext2);
                        results = dispatcher2.dispatchToGroup(new IdentityCommand(), Set.of(group2.getLocalMember()));
                        result = (CompletionStage)results.get(group1.getLocalMember());
                        if (result != null) {
                            Assertions.assertThatExceptionOfType(CancellationException.class).isThrownBy(result.toCompletableFuture()::join);
                        }
                        Assertions.assertThat((CompletionStage)((CompletionStage)results.get(group2.getLocalMember()))).isNull();
                    }
                }
            }
        }
    }
}

