/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.jgroups;

import org.jgroups.JChannel;
import org.wildfly.clustering.context.AbstractContext;
import org.wildfly.clustering.server.jgroups.JChannelFactory;

public class JChannelContext
extends AbstractContext<JChannel> {
    private final JChannel channel;

    public JChannelContext(String clusterName, String memberName) {
        this.channel = JChannelFactory.INSTANCE.apply(memberName);
        this.accept(() -> ((JChannel)this.channel).close());
        try {
            this.channel.connect(clusterName);
            this.accept(() -> ((JChannel)this.channel).disconnect());
        }
        catch (Error | RuntimeException e) {
            this.close();
            throw e;
        }
        catch (Exception e) {
            this.close();
            throw new RuntimeException(e);
        }
    }

    public JChannel get() {
        return this.channel;
    }
}

