/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.local.provider;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.wildfly.clustering.server.local.LocalGroup;
import org.wildfly.clustering.server.local.LocalGroupMember;
import org.wildfly.clustering.server.local.provider.DefaultServiceProviderRegistration;
import org.wildfly.clustering.server.provider.ServiceProviderListener;
import org.wildfly.clustering.server.provider.ServiceProviderRegistration;
import org.wildfly.clustering.server.provider.ServiceProviderRegistry;

public class LocalServiceProviderRegistry<T>
implements ServiceProviderRegistry<T, LocalGroupMember> {
    private final Set<T> services = ConcurrentHashMap.newKeySet();
    private final LocalGroup group;

    public LocalServiceProviderRegistry(LocalGroup group) {
        this.group = group;
    }

    public LocalGroup getGroup() {
        return this.group;
    }

    public ServiceProviderRegistration<T, LocalGroupMember> register(T service) {
        this.services.add(service);
        return new DefaultServiceProviderRegistration(this, service, () -> this.services.remove(service));
    }

    public ServiceProviderRegistration<T, LocalGroupMember> register(T service, ServiceProviderListener<LocalGroupMember> listener) {
        return this.register(service);
    }

    public Set<LocalGroupMember> getProviders(T service) {
        return this.services.contains(service) ? Set.of((LocalGroupMember)this.group.getLocalMember()) : Set.of();
    }

    public Set<T> getServices() {
        return Collections.unmodifiableSet(this.services);
    }
}

