/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.local.registry;

import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.server.GroupMember;
import org.wildfly.clustering.server.local.LocalGroup;
import org.wildfly.clustering.server.local.LocalGroupMember;
import org.wildfly.clustering.server.local.registry.LocalRegistry;

public class LocalRegistryTestCase {
    @Test
    public void test() {
        LocalGroup group = (LocalGroup)Mockito.mock(LocalGroup.class);
        LocalGroupMember localMember = (LocalGroupMember)Mockito.mock(LocalGroupMember.class);
        LocalGroupMember nonMember = (LocalGroupMember)Mockito.mock(LocalGroupMember.class);
        Runnable closeTask = (Runnable)Mockito.mock(Runnable.class);
        Map.Entry<String, String> entry = Map.entry("foo", "bar");
        ((LocalGroup)Mockito.doReturn((Object)localMember).when((Object)group)).getLocalMember();
        LocalRegistry registry = new LocalRegistry(group, entry, closeTask);
        Assertions.assertSame((Object)group, (Object)registry.getGroup());
        Assertions.assertSame(entry, (Object)registry.getEntry((GroupMember)localMember));
        Assertions.assertNull((Object)registry.getEntry((GroupMember)nonMember));
        Assertions.assertEquals(Map.ofEntries(entry), (Object)registry.getEntries());
        Mockito.verifyNoInteractions((Object[])new Object[]{closeTask});
        registry.close();
        ((Runnable)Mockito.verify((Object)closeTask)).run();
        Assertions.assertNull((Object)registry.getEntry((GroupMember)localMember));
        Assertions.assertNull((Object)registry.getEntry((GroupMember)nonMember));
        Assertions.assertEquals(Map.of(), (Object)registry.getEntries());
        registry.close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{closeTask});
    }
}

