/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.local.provider;

import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.server.local.LocalGroup;
import org.wildfly.clustering.server.local.LocalGroupMember;
import org.wildfly.clustering.server.local.provider.LocalServiceProviderRegistrar;
import org.wildfly.clustering.server.provider.ServiceProviderRegistration;

public class LocalServiceProviderRegistrarTestCase {
    @Test
    public void test() {
        LocalGroup group = (LocalGroup)Mockito.mock(LocalGroup.class);
        LocalGroupMember localMember = (LocalGroupMember)Mockito.mock(LocalGroupMember.class);
        ((LocalGroup)Mockito.doReturn((Object)localMember).when((Object)group)).getLocalMember();
        LocalServiceProviderRegistrar registrar = LocalServiceProviderRegistrar.of((LocalGroup)group);
        Assertions.assertSame((Object)group, (Object)registrar.getGroup());
        Assertions.assertEquals(Set.of(), (Object)registrar.getServices());
        Assertions.assertEquals(Set.of(), (Object)registrar.getProviders((Object)"foo"));
        Assertions.assertEquals(Set.of(), (Object)registrar.getProviders((Object)"bar"));
        ServiceProviderRegistration foo = registrar.register((Object)"foo");
        Assertions.assertEquals((Object)"foo", (Object)foo.getService());
        Assertions.assertEquals(Set.of(localMember), (Object)foo.getProviders());
        Assertions.assertEquals(Set.of("foo"), (Object)registrar.getServices());
        Assertions.assertEquals(Set.of(localMember), (Object)registrar.getProviders((Object)"foo"));
        Assertions.assertEquals(Set.of(), (Object)registrar.getProviders((Object)"bar"));
        ServiceProviderRegistration bar = registrar.register((Object)"bar");
        Assertions.assertEquals((Object)"bar", (Object)bar.getService());
        Assertions.assertEquals(Set.of(localMember), (Object)bar.getProviders());
        Assertions.assertEquals(Set.of("foo", "bar"), (Object)registrar.getServices());
        Assertions.assertEquals(Set.of(localMember), (Object)registrar.getProviders((Object)"foo"));
        Assertions.assertEquals(Set.of(localMember), (Object)registrar.getProviders((Object)"bar"));
        foo.close();
        Assertions.assertEquals(Set.of("bar"), (Object)registrar.getServices());
        Assertions.assertEquals(Set.of(), (Object)registrar.getProviders((Object)"foo"));
        Assertions.assertEquals(Set.of(localMember), (Object)registrar.getProviders((Object)"bar"));
        bar.close();
        Assertions.assertEquals(Set.of(), (Object)registrar.getServices());
        Assertions.assertEquals(Set.of(), (Object)registrar.getProviders((Object)"foo"));
        Assertions.assertEquals(Set.of(), (Object)registrar.getProviders((Object)"bar"));
    }
}

