/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.local.scheduler;

import java.time.Duration;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.UnaryOperator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.server.local.scheduler.ScheduledEntries;

public abstract class AbstractScheduledEntriesTestCase {
    private final ScheduledEntries<UUID, Instant> entrySet;
    private final UnaryOperator<List<Map.Entry<UUID, Instant>>> expectedFactory;

    AbstractScheduledEntriesTestCase(ScheduledEntries<UUID, Instant> entrySet, UnaryOperator<List<Map.Entry<UUID, Instant>>> expectedFactory) {
        this.entrySet = entrySet;
        this.expectedFactory = expectedFactory;
    }

    @Test
    public void test() {
        Map.Entry result;
        Assertions.assertFalse((boolean)this.entrySet.iterator().hasNext());
        LinkedList<AbstractMap.SimpleImmutableEntry<UUID, Instant>> entries = new LinkedList<AbstractMap.SimpleImmutableEntry<UUID, Instant>>();
        Instant now = Instant.now();
        entries.add(new AbstractMap.SimpleImmutableEntry<UUID, Instant>(UUID.randomUUID(), now));
        entries.add(new AbstractMap.SimpleImmutableEntry<UUID, Instant>(UUID.randomUUID(), now));
        entries.add(new AbstractMap.SimpleImmutableEntry<UUID, Instant>(UUID.randomUUID(), now.minus(Duration.ofSeconds(1L))));
        entries.add(new AbstractMap.SimpleImmutableEntry<UUID, Instant>(UUID.randomUUID(), now.plus(Duration.ofSeconds(2L))));
        entries.add(new AbstractMap.SimpleImmutableEntry<UUID, Instant>(UUID.randomUUID(), now.plus(Duration.ofSeconds(1L))));
        for (Map.Entry entry : entries) {
            this.entrySet.add((Object)((UUID)entry.getKey()), (Object)((Instant)entry.getValue()));
        }
        List expected = (List)this.expectedFactory.apply(entries);
        Assertions.assertEquals((int)5, (int)expected.size());
        Iterator iterator = this.entrySet.iterator();
        for (Map.Entry entry : expected) {
            Assertions.assertTrue((boolean)iterator.hasNext());
            result = (Map.Entry)iterator.next();
            Assertions.assertSame(entry.getKey(), result.getKey());
            Assertions.assertSame(entry.getValue(), result.getValue());
        }
        Assertions.assertFalse((boolean)iterator.hasNext());
        this.entrySet.remove((Object)((UUID)((Map.Entry)expected.remove(0)).getKey()));
        Iterator iterator2 = this.entrySet.iterator();
        for (Map.Entry entry : expected) {
            Assertions.assertTrue((boolean)iterator2.hasNext());
            result = (Map.Entry)iterator2.next();
            Assertions.assertSame(entry.getKey(), result.getKey());
            Assertions.assertSame(entry.getValue(), result.getValue());
        }
        Assertions.assertFalse((boolean)iterator2.hasNext());
        this.entrySet.remove((Object)((UUID)((Map.Entry)expected.remove((expected.size() - 1) / 2)).getKey()));
        Iterator iterator3 = this.entrySet.iterator();
        for (Map.Entry entry : expected) {
            Assertions.assertTrue((boolean)iterator3.hasNext());
            result = (Map.Entry)iterator3.next();
            Assertions.assertSame(entry.getKey(), result.getKey());
            Assertions.assertSame(entry.getValue(), result.getValue());
        }
        Assertions.assertFalse((boolean)iterator3.hasNext());
        this.entrySet.remove((Object)((UUID)((Map.Entry)expected.remove(expected.size() - 1)).getKey()));
        Iterator iterator4 = this.entrySet.iterator();
        for (Map.Entry entry : expected) {
            Assertions.assertTrue((boolean)iterator4.hasNext());
            result = (Map.Entry)iterator4.next();
            Assertions.assertSame(entry.getKey(), result.getKey());
            Assertions.assertSame(entry.getValue(), result.getValue());
        }
        Assertions.assertFalse((boolean)iterator4.hasNext());
        this.entrySet.remove((Object)UUID.randomUUID());
    }
}

